<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSafCcdPurgeBlockLearnedRoutes StructType
 * @subpackage Structs
 */
class XSafCcdPurgeBlockLearnedRoutes extends AbstractStructBase
{
    /**
     * The learnedPattern
     * Meta information extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $learnedPattern;
    /**
     * The learnedPatternPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The callControlIdentity
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callControlIdentity;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * Constructor method for XSafCcdPurgeBlockLearnedRoutes
     * @uses XSafCcdPurgeBlockLearnedRoutes::setLearnedPattern()
     * @uses XSafCcdPurgeBlockLearnedRoutes::setLearnedPatternPrefix()
     * @uses XSafCcdPurgeBlockLearnedRoutes::setCallControlIdentity()
     * @uses XSafCcdPurgeBlockLearnedRoutes::setIpAddress()
     * @param string $learnedPattern
     * @param string $learnedPatternPrefix
     * @param string $callControlIdentity
     * @param string $ipAddress
     */
    public function __construct($learnedPattern = null, $learnedPatternPrefix = null, $callControlIdentity = null, $ipAddress = null)
    {
        $this
            ->setLearnedPattern($learnedPattern)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setCallControlIdentity($callControlIdentity)
            ->setIpAddress($ipAddress);
    }
    /**
     * Get learnedPattern value
     * @return string|null
     */
    public function getLearnedPattern()
    {
        return $this->learnedPattern;
    }
    /**
     * Set learnedPattern value
     * @param string $learnedPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSafCcdPurgeBlockLearnedRoutes
     */
    public function setLearnedPattern($learnedPattern = null)
    {
        // validation for constraint: string
        if (!is_null($learnedPattern) && !is_string($learnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedPattern, true), gettype($learnedPattern)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($learnedPattern) && mb_strlen($learnedPattern) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($learnedPattern)), __LINE__);
        }
        $this->learnedPattern = $learnedPattern;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSafCcdPurgeBlockLearnedRoutes
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedPatternPrefix, true), gettype($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($learnedPatternPrefix) && mb_strlen($learnedPatternPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get callControlIdentity value
     * @return string|null
     */
    public function getCallControlIdentity()
    {
        return $this->callControlIdentity;
    }
    /**
     * Set callControlIdentity value
     * @param string $callControlIdentity
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSafCcdPurgeBlockLearnedRoutes
     */
    public function setCallControlIdentity($callControlIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($callControlIdentity) && !is_string($callControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callControlIdentity, true), gettype($callControlIdentity)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callControlIdentity) && mb_strlen($callControlIdentity) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callControlIdentity)), __LINE__);
        }
        $this->callControlIdentity = $callControlIdentity;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSafCcdPurgeBlockLearnedRoutes
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ipAddress) && mb_strlen($ipAddress) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
}
