<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteListMember StructType
 * @subpackage Structs
 */
class XRouteListMember extends AbstractStructBase
{
    /**
     * The routeGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeGroupName;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $selectionOrder;
    /**
     * The useFullyQualifiedCallingPartyNumber
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $useFullyQualifiedCallingPartyNumber;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * Constructor method for XRouteListMember
     * @uses XRouteListMember::setRouteGroupName()
     * @uses XRouteListMember::setSelectionOrder()
     * @uses XRouteListMember::setUseFullyQualifiedCallingPartyNumber()
     * @uses XRouteListMember::setCalledPartyTransformationMask()
     * @uses XRouteListMember::setCallingPartyTransformationMask()
     * @uses XRouteListMember::setDigitDiscardInstructionName()
     * @uses XRouteListMember::setCallingPartyPrefixDigits()
     * @uses XRouteListMember::setPrefixDigitsOut()
     * @uses XRouteListMember::setCallingPartyNumberingPlan()
     * @uses XRouteListMember::setCallingPartyNumberType()
     * @uses XRouteListMember::setCalledPartyNumberingPlan()
     * @uses XRouteListMember::setCalledPartyNumberType()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName
     * @param string $selectionOrder
     * @param string $useFullyQualifiedCallingPartyNumber
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $callingPartyPrefixDigits
     * @param string $prefixDigitsOut
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName = null, $selectionOrder = null, $useFullyQualifiedCallingPartyNumber = 'Default', $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $callingPartyPrefixDigits = null, $prefixDigitsOut = null, $callingPartyNumberingPlan = 'Cisco CallManager', $callingPartyNumberType = 'Cisco CallManager', $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager')
    {
        $this
            ->setRouteGroupName($routeGroupName)
            ->setSelectionOrder($selectionOrder)
            ->setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType);
    }
    /**
     * Get routeGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRouteGroupName()
    {
        return $this->routeGroupName;
    }
    /**
     * Set routeGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setRouteGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName = null)
    {
        $this->routeGroupName = $routeGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get useFullyQualifiedCallingPartyNumber value
     * @return string
     */
    public function getUseFullyQualifiedCallingPartyNumber()
    {
        return $this->useFullyQualifiedCallingPartyNumber;
    }
    /**
     * Set useFullyQualifiedCallingPartyNumber value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useFullyQualifiedCallingPartyNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useFullyQualifiedCallingPartyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useFullyQualifiedCallingPartyNumber) ? implode(', ', $useFullyQualifiedCallingPartyNumber) : var_export($useFullyQualifiedCallingPartyNumber, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useFullyQualifiedCallingPartyNumber = $useFullyQualifiedCallingPartyNumber;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyTransformationMask, true), gettype($calledPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($calledPartyTransformationMask) && mb_strlen($calledPartyTransformationMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($calledPartyTransformationMask)), __LINE__);
        }
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyTransformationMask) && mb_strlen($callingPartyTransformationMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyTransformationMask)), __LINE__);
        }
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return isset($this->digitDiscardInstructionName) ? $this->digitDiscardInstructionName : null;
    }
    /**
     * Set digitDiscardInstructionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        if (is_null($digitDiscardInstructionName) || (is_array($digitDiscardInstructionName) && empty($digitDiscardInstructionName))) {
            unset($this->digitDiscardInstructionName);
        } else {
            $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return isset($this->prefixDigitsOut) ? $this->prefixDigitsOut : null;
    }
    /**
     * Set prefixDigitsOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDigitsOut
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigitsOut, true), gettype($prefixDigitsOut)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prefixDigitsOut) && mb_strlen($prefixDigitsOut) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($prefixDigitsOut)), __LINE__);
        }
        if (is_null($prefixDigitsOut) || (is_array($prefixDigitsOut) && empty($prefixDigitsOut))) {
            unset($this->prefixDigitsOut);
        } else {
            $this->prefixDigitsOut = $prefixDigitsOut;
        }
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($callingPartyNumberingPlan) ? implode(', ', $callingPartyNumberingPlan) : var_export($callingPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCallingPartyNumberType($callingPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($callingPartyNumberType) ? implode(', ', $callingPartyNumberType) : var_export($callingPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($calledPartyNumberingPlan) ? implode(', ', $calledPartyNumberingPlan) : var_export($calledPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteListMember
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($calledPartyNumberType) ? implode(', ', $calledPartyNumberType) : var_export($calledPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
}
