<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteFilterMember StructType
 * @subpackage Structs
 */
class XRouteFilterMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanTagName;
    /**
     * The operator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $operator;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * The digits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digits;
    /**
     * Constructor method for XRouteFilterMember
     * @uses XRouteFilterMember::setDialPlanTagName()
     * @uses XRouteFilterMember::setOperator()
     * @uses XRouteFilterMember::setPriority()
     * @uses XRouteFilterMember::setDigits()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName
     * @param string $operator
     * @param string $priority
     * @param string $digits
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName = null, $operator = null, $priority = null, $digits = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setOperator($operator)
            ->setPriority($priority)
            ->setDigits($digits);
    }
    /**
     * Get dialPlanTagName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteFilterMember
     */
    public function setDialPlanTagName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XOperator::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteFilterMember
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteFilterMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get digits value
     * @return string|null
     */
    public function getDigits()
    {
        return $this->digits;
    }
    /**
     * Set digits value
     * @param string $digits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRouteFilterMember
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: string
        if (!is_null($digits) && !is_string($digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digits, true), gettype($digits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($digits) && mb_strlen($digits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($digits)), __LINE__);
        }
        $this->digits = $digits;
        return $this;
    }
}
