<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRegion StructType
 * @subpackage Structs
 */
class XRegion extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The relatedRegions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RelatedRegions
     */
    public $relatedRegions;
    /**
     * The defaultCodec
     * Meta information extracted from the WSDL
     * - documentation: Not valid for get and list
     * - default: G.711
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $defaultCodec;
    /**
     * Constructor method for XRegion
     * @uses XRegion::setName()
     * @uses XRegion::setRelatedRegions()
     * @uses XRegion::setDefaultCodec()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RelatedRegions $relatedRegions
     * @param string $defaultCodec
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\RelatedRegions $relatedRegions = null, $defaultCodec = 'G.711')
    {
        $this
            ->setName($name)
            ->setRelatedRegions($relatedRegions)
            ->setDefaultCodec($defaultCodec);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegion
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get relatedRegions value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RelatedRegions|null
     */
    public function getRelatedRegions()
    {
        return $this->relatedRegions;
    }
    /**
     * Set relatedRegions value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RelatedRegions $relatedRegions
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegion
     */
    public function setRelatedRegions(\Losc\CucmBundle\Model\Webservice\StructType\RelatedRegions $relatedRegions = null)
    {
        $this->relatedRegions = $relatedRegions;
        return $this;
    }
    /**
     * Get defaultCodec value
     * @return string|null
     */
    public function getDefaultCodec()
    {
        return $this->defaultCodec;
    }
    /**
     * Set defaultCodec value
     * @param string $defaultCodec
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegion
     */
    public function setDefaultCodec($defaultCodec = 'G.711')
    {
        // validation for constraint: string
        if (!is_null($defaultCodec) && !is_string($defaultCodec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCodec, true), gettype($defaultCodec)), __LINE__);
        }
        $this->defaultCodec = $defaultCodec;
        return $this;
    }
}
