<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XProcessNodeService StructType
 * @subpackage Structs
 */
class XProcessNodeService extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The traceLevel
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $traceLevel;
    /**
     * The userCategories
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userCategories;
    /**
     * The enable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enable;
    /**
     * The numFiles
     * Meta information extracted from the WSDL
     * - default: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numFiles;
    /**
     * The maxFileSize
     * Meta information extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxFileSize;
    /**
     * Constructor method for XProcessNodeService
     * @uses XProcessNodeService::setProcessNodeName()
     * @uses XProcessNodeService::setService()
     * @uses XProcessNodeService::setTraceLevel()
     * @uses XProcessNodeService::setUserCategories()
     * @uses XProcessNodeService::setEnable()
     * @uses XProcessNodeService::setNumFiles()
     * @uses XProcessNodeService::setMaxFileSize()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $service
     * @param string $traceLevel
     * @param string $userCategories
     * @param string $enable
     * @param string $numFiles
     * @param string $maxFileSize
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $service = null, $traceLevel = '0', $userCategories = '0', $enable = 'false', $numFiles = '250', $maxFileSize = '1')
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setService($service)
            ->setTraceLevel($traceLevel)
            ->setUserCategories($userCategories)
            ->setEnable($enable)
            ->setNumFiles($numFiles)
            ->setMaxFileSize($maxFileSize);
    }
    /**
     * Get processNodeName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setProcessNodeName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XService', is_array($service) ? implode(', ', $service) : var_export($service, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get traceLevel value
     * @return string|null
     */
    public function getTraceLevel()
    {
        return $this->traceLevel;
    }
    /**
     * Set traceLevel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traceLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setTraceLevel($traceLevel = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($traceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($traceLevel) ? implode(', ', $traceLevel) : var_export($traceLevel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->traceLevel = $traceLevel;
        return $this;
    }
    /**
     * Get userCategories value
     * @return string|null
     */
    public function getUserCategories()
    {
        return $this->userCategories;
    }
    /**
     * Set userCategories value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userCategories
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setUserCategories($userCategories = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($userCategories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($userCategories) ? implode(', ', $userCategories) : var_export($userCategories, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->userCategories = $userCategories;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setEnable($enable = 'false')
    {
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enable, true), gettype($enable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enable, true)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get numFiles value
     * @return string|null
     */
    public function getNumFiles()
    {
        return $this->numFiles;
    }
    /**
     * Set numFiles value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numFiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setNumFiles($numFiles = '250')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numFiles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numFiles) ? implode(', ', $numFiles) : var_export($numFiles, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numFiles = $numFiles;
        return $this;
    }
    /**
     * Get maxFileSize value
     * @return string|null
     */
    public function getMaxFileSize()
    {
        return $this->maxFileSize;
    }
    /**
     * Set maxFileSize value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxFileSize
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNodeService
     */
    public function setMaxFileSize($maxFileSize = '1')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxFileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxFileSize) ? implode(', ', $maxFileSize) : var_export($maxFileSize, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxFileSize = $maxFileSize;
        return $this;
    }
}
