<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMobileVoiceMember StructType
 * @subpackage Structs
 */
class XMobileVoiceMember extends AbstractStructBase
{
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $userLocale;
    /**
     * The orderIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $orderIndex;
    /**
     * Constructor method for XMobileVoiceMember
     * @uses XMobileVoiceMember::setUserLocale()
     * @uses XMobileVoiceMember::setOrderIndex()
     * @param string $userLocale
     * @param string $orderIndex
     */
    public function __construct($userLocale = null, $orderIndex = null)
    {
        $this
            ->setUserLocale($userLocale)
            ->setOrderIndex($orderIndex);
    }
    /**
     * Get userLocale value
     * @return string
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XMobileVoiceMember
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($userLocale) ? implode(', ', $userLocale) : var_export($userLocale, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get orderIndex value
     * @return string
     */
    public function getOrderIndex()
    {
        return $this->orderIndex;
    }
    /**
     * Set orderIndex value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderIndex
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XMobileVoiceMember
     */
    public function setOrderIndex($orderIndex = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($orderIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($orderIndex) ? implode(', ', $orderIndex) : var_export($orderIndex, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->orderIndex = $orderIndex;
        return $this;
    }
}
