<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMediaResourceGroup StructType
 * @subpackage Structs
 */
class XMediaResourceGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The multicast
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XMediaResourceGroup
     * @uses XMediaResourceGroup::setName()
     * @uses XMediaResourceGroup::setMulticast()
     * @uses XMediaResourceGroup::setMembers()
     * @uses XMediaResourceGroup::setDescription()
     * @param string $name
     * @param string $multicast
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $description
     */
    public function __construct($name = null, $multicast = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $description = null)
    {
        $this
            ->setName($name)
            ->setMulticast($multicast)
            ->setMembers($members)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XMediaResourceGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get multicast value
     * @return string
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XMediaResourceGroup
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multicast, true), gettype($multicast)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($multicast, true)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XMediaResourceGroup
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XMediaResourceGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
