<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLine StructType
 * @subpackage Structs
 */
class XLine extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $usage;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The aarDestinationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarKeepCallHistory
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarKeepCallHistory;
    /**
     * The aarVoiceMailEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarVoiceMailEnabled;
    /**
     * The callForwardAll
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - default: Auto Answer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The alertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - default: No Error
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $releaseClause;
    /**
     * The hrDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hrDuration;
    /**
     * The hrInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hrInterval;
    /**
     * The cfaCssPolicy
     * Meta information extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parkMonForwardNoRetrieveDn;
    /**
     * The parkMonForwardNoRetrieveIntDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parkMonForwardNoRetrieveIntDn;
    /**
     * The parkMonForwardNoRetrieveVmEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveVmEnabled;
    /**
     * The parkMonForwardNoRetrieveIntVmEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveIntVmEnabled;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The parkMonReversionTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parkMonReversionTimer;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The allowCtiControlFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The rejectAnonymousCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousCall;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The pstnFailover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailover;
    /**
     * The callControlAgentProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callControlAgentProfile;
    /**
     * The useEnterpriseAltNum
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete enterpriseAltNumber.Use only while update
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useEnterpriseAltNum;
    /**
     * The useE164AltNum
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete e164AltNumber
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useE164AltNum;
    /**
     * The active
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $active;
    /**
     * Constructor method for XLine
     * @uses XLine::setPattern()
     * @uses XLine::setUsage()
     * @uses XLine::setDescription()
     * @uses XLine::setRoutePartitionName()
     * @uses XLine::setAarNeighborhoodName()
     * @uses XLine::setAarDestinationMask()
     * @uses XLine::setAarKeepCallHistory()
     * @uses XLine::setAarVoiceMailEnabled()
     * @uses XLine::setCallForwardAll()
     * @uses XLine::setCallForwardBusy()
     * @uses XLine::setCallForwardBusyInt()
     * @uses XLine::setCallForwardNoAnswer()
     * @uses XLine::setCallForwardNoAnswerInt()
     * @uses XLine::setCallForwardNoCoverage()
     * @uses XLine::setCallForwardNoCoverageInt()
     * @uses XLine::setCallForwardOnFailure()
     * @uses XLine::setCallForwardAlternateParty()
     * @uses XLine::setCallForwardNotRegistered()
     * @uses XLine::setCallForwardNotRegisteredInt()
     * @uses XLine::setCallPickupGroupName()
     * @uses XLine::setAutoAnswer()
     * @uses XLine::setNetworkHoldMohAudioSourceId()
     * @uses XLine::setUserHoldMohAudioSourceId()
     * @uses XLine::setAlertingName()
     * @uses XLine::setAsciiAlertingName()
     * @uses XLine::setPresenceGroupName()
     * @uses XLine::setShareLineAppearanceCssName()
     * @uses XLine::setVoiceMailProfileName()
     * @uses XLine::setPatternPrecedence()
     * @uses XLine::setReleaseClause()
     * @uses XLine::setHrDuration()
     * @uses XLine::setHrInterval()
     * @uses XLine::setCfaCssPolicy()
     * @uses XLine::setDefaultActivatedDeviceName()
     * @uses XLine::setParkMonForwardNoRetrieveDn()
     * @uses XLine::setParkMonForwardNoRetrieveIntDn()
     * @uses XLine::setParkMonForwardNoRetrieveVmEnabled()
     * @uses XLine::setParkMonForwardNoRetrieveIntVmEnabled()
     * @uses XLine::setParkMonForwardNoRetrieveCssName()
     * @uses XLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses XLine::setParkMonReversionTimer()
     * @uses XLine::setPartyEntranceTone()
     * @uses XLine::setDirectoryURIs()
     * @uses XLine::setAllowCtiControlFlag()
     * @uses XLine::setRejectAnonymousCall()
     * @uses XLine::setPatternUrgency()
     * @uses XLine::setConfidentialAccess()
     * @uses XLine::setExternalCallControlProfile()
     * @uses XLine::setEnterpriseAltNum()
     * @uses XLine::setE164AltNum()
     * @uses XLine::setPstnFailover()
     * @uses XLine::setCallControlAgentProfile()
     * @uses XLine::setUseEnterpriseAltNum()
     * @uses XLine::setUseE164AltNum()
     * @uses XLine::setActive()
     * @param string $pattern
     * @param string $usage
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $aarDestinationMask
     * @param string $aarKeepCallHistory
     * @param string $aarVoiceMailEnabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAll $callForwardAll
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy $callForwardBusy
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusyInt $callForwardBusyInt
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswer $callForwardNoAnswer
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverage $callForwardNoCoverage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardOnFailure $callForwardOnFailure
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAlternateParty $callForwardAlternateParty
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegistered $callForwardNotRegistered
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @param string $autoAnswer
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $hrDuration
     * @param string $hrInterval
     * @param string $cfaCssPolicy
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName
     * @param string $parkMonForwardNoRetrieveDn
     * @param string $parkMonForwardNoRetrieveIntDn
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @param string $parkMonReversionTimer
     * @param string $partyEntranceTone
     * @param \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs
     * @param string $allowCtiControlFlag
     * @param string $rejectAnonymousCall
     * @param string $patternUrgency
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile
     * @param \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @param string $pstnFailover
     * @param string $callControlAgentProfile
     * @param string $useEnterpriseAltNum
     * @param string $useE164AltNum
     * @param string $active
     */
    public function __construct($pattern = null, $usage = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $aarDestinationMask = null, $aarKeepCallHistory = null, $aarVoiceMailEnabled = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAll $callForwardAll = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy $callForwardBusy = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusyInt $callForwardBusyInt = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswer $callForwardNoAnswer = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverage $callForwardNoCoverage = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardOnFailure $callForwardOnFailure = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAlternateParty $callForwardAlternateParty = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegistered $callForwardNotRegistered = null, \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null, $autoAnswer = 'Auto Answer Off', $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $alertingName = null, $asciiAlertingName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null, $patternPrecedence = 'Default', $releaseClause = 'No Error', $hrDuration = null, $hrInterval = null, $cfaCssPolicy = 'Use System Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName = null, $parkMonForwardNoRetrieveDn = null, $parkMonForwardNoRetrieveIntDn = null, $parkMonForwardNoRetrieveVmEnabled = null, $parkMonForwardNoRetrieveIntVmEnabled = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null, $parkMonReversionTimer = null, $partyEntranceTone = 'Default', \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs = null, $allowCtiControlFlag = 'true', $rejectAnonymousCall = null, $patternUrgency = 'false', \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile = null, \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null, \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null, $pstnFailover = null, $callControlAgentProfile = null, $useEnterpriseAltNum = null, $useE164AltNum = null, $active = 'true')
    {
        $this
            ->setPattern($pattern)
            ->setUsage($usage)
            ->setDescription($description)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarKeepCallHistory($aarKeepCallHistory)
            ->setAarVoiceMailEnabled($aarVoiceMailEnabled)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setHrDuration($hrDuration)
            ->setHrInterval($hrInterval)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn)
            ->setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn)
            ->setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled)
            ->setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setParkMonReversionTimer($parkMonReversionTimer)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setRejectAnonymousCall($rejectAnonymousCall)
            ->setPatternUrgency($patternUrgency)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setPstnFailover($pstnFailover)
            ->setCallControlAgentProfile($callControlAgentProfile)
            ->setUseEnterpriseAltNum($useEnterpriseAltNum)
            ->setUseE164AltNum($useE164AltNum)
            ->setActive($active);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get usage value
     * @return string
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return isset($this->aarDestinationMask) ? $this->aarDestinationMask : null;
    }
    /**
     * Set aarDestinationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aarDestinationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        // validation for constraint: string
        if (!is_null($aarDestinationMask) && !is_string($aarDestinationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aarDestinationMask, true), gettype($aarDestinationMask)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aarDestinationMask) && mb_strlen($aarDestinationMask) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aarDestinationMask)), __LINE__);
        }
        if (is_null($aarDestinationMask) || (is_array($aarDestinationMask) && empty($aarDestinationMask))) {
            unset($this->aarDestinationMask);
        } else {
            $this->aarDestinationMask = $aarDestinationMask;
        }
        return $this;
    }
    /**
     * Get aarKeepCallHistory value
     * @return string|null
     */
    public function getAarKeepCallHistory()
    {
        return $this->aarKeepCallHistory;
    }
    /**
     * Set aarKeepCallHistory value
     * @param string $aarKeepCallHistory
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAarKeepCallHistory($aarKeepCallHistory = null)
    {
        // validation for constraint: string
        if (!is_null($aarKeepCallHistory) && !is_string($aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aarKeepCallHistory, true), gettype($aarKeepCallHistory)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($aarKeepCallHistory) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($aarKeepCallHistory, true)), __LINE__);
        }
        $this->aarKeepCallHistory = $aarKeepCallHistory;
        return $this;
    }
    /**
     * Get aarVoiceMailEnabled value
     * @return string|null
     */
    public function getAarVoiceMailEnabled()
    {
        return $this->aarVoiceMailEnabled;
    }
    /**
     * Set aarVoiceMailEnabled value
     * @param string $aarVoiceMailEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAarVoiceMailEnabled($aarVoiceMailEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($aarVoiceMailEnabled) && !is_string($aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aarVoiceMailEnabled, true), gettype($aarVoiceMailEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($aarVoiceMailEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($aarVoiceMailEnabled, true)), __LINE__);
        }
        $this->aarVoiceMailEnabled = $aarVoiceMailEnabled;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAll $callForwardAll
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardAll(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy $callForwardBusy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardBusy(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusyInt $callForwardBusyInt
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardBusyInt(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswer $callForwardNoAnswer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardNoAnswer(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardNoAnswerInt(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverage $callForwardNoCoverage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardNoCoverage(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardNoCoverageInt(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardOnFailure $callForwardOnFailure
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardOnFailure(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAlternateParty $callForwardAlternateParty
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardAlternateParty(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegistered $callForwardNotRegistered
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardNotRegistered(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallForwardNotRegisteredInt(\Losc\CucmBundle\Model\Webservice\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallPickupGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAnswer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAutoAnswer($autoAnswer = 'Auto Answer Off')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::valueIsValid($autoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer', is_array($autoAnswer) ? implode(', ', $autoAnswer) : var_export($autoAnswer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::getValidValues())), __LINE__);
        }
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($networkHoldMohAudioSourceId) ? implode(', ', $networkHoldMohAudioSourceId) : var_export($networkHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($userHoldMohAudioSourceId) ? implode(', ', $userHoldMohAudioSourceId) : var_export($userHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alertingName, true), gettype($alertingName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($alertingName) && mb_strlen($alertingName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        // validation for constraint: string
        if (!is_null($asciiAlertingName) && !is_string($asciiAlertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiAlertingName, true), gettype($asciiAlertingName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($asciiAlertingName) && mb_strlen($asciiAlertingName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($asciiAlertingName)), __LINE__);
        }
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setPresenceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return isset($this->shareLineAppearanceCssName) ? $this->shareLineAppearanceCssName : null;
    }
    /**
     * Set shareLineAppearanceCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setShareLineAppearanceCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName = null)
    {
        if (is_null($shareLineAppearanceCssName) || (is_array($shareLineAppearanceCssName) && empty($shareLineAppearanceCssName))) {
            unset($this->shareLineAppearanceCssName);
        } else {
            $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        }
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return isset($this->voiceMailProfileName) ? $this->voiceMailProfileName : null;
    }
    /**
     * Set voiceMailProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setVoiceMailProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null)
    {
        if (is_null($voiceMailProfileName) || (is_array($voiceMailProfileName) && empty($voiceMailProfileName))) {
            unset($this->voiceMailProfileName);
        } else {
            $this->voiceMailProfileName = $voiceMailProfileName;
        }
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setReleaseClause($releaseClause = 'No Error')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue', is_array($releaseClause) ? implode(', ', $releaseClause) : var_export($releaseClause, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get hrDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHrDuration()
    {
        return isset($this->hrDuration) ? $this->hrDuration : null;
    }
    /**
     * Set hrDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrDuration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setHrDuration($hrDuration = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($hrDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($hrDuration) ? implode(', ', $hrDuration) : var_export($hrDuration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($hrDuration) || (is_array($hrDuration) && empty($hrDuration))) {
            unset($this->hrDuration);
        } else {
            $this->hrDuration = $hrDuration;
        }
        return $this;
    }
    /**
     * Get hrInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHrInterval()
    {
        return isset($this->hrInterval) ? $this->hrInterval : null;
    }
    /**
     * Set hrInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setHrInterval($hrInterval = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($hrInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($hrInterval) ? implode(', ', $hrInterval) : var_export($hrInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($hrInterval) || (is_array($hrInterval) && empty($hrInterval))) {
            unset($this->hrInterval);
        } else {
            $this->hrInterval = $hrInterval;
        }
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return string|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cfaCssPolicy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCfaCssPolicy($cfaCssPolicy = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::valueIsValid($cfaCssPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy', is_array($cfaCssPolicy) ? implode(', ', $cfaCssPolicy) : var_export($cfaCssPolicy, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::getValidValues())), __LINE__);
        }
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return isset($this->defaultActivatedDeviceName) ? $this->defaultActivatedDeviceName : null;
    }
    /**
     * Set defaultActivatedDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setDefaultActivatedDeviceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName = null)
    {
        if (is_null($defaultActivatedDeviceName) || (is_array($defaultActivatedDeviceName) && empty($defaultActivatedDeviceName))) {
            unset($this->defaultActivatedDeviceName);
        } else {
            $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveDn()
    {
        return isset($this->parkMonForwardNoRetrieveDn) ? $this->parkMonForwardNoRetrieveDn : null;
    }
    /**
     * Set parkMonForwardNoRetrieveDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parkMonForwardNoRetrieveDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveDn) && !is_string($parkMonForwardNoRetrieveDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveDn, true), gettype($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parkMonForwardNoRetrieveDn) && mb_strlen($parkMonForwardNoRetrieveDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        if (is_null($parkMonForwardNoRetrieveDn) || (is_array($parkMonForwardNoRetrieveDn) && empty($parkMonForwardNoRetrieveDn))) {
            unset($this->parkMonForwardNoRetrieveDn);
        } else {
            $this->parkMonForwardNoRetrieveDn = $parkMonForwardNoRetrieveDn;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntDn()
    {
        return isset($this->parkMonForwardNoRetrieveIntDn) ? $this->parkMonForwardNoRetrieveIntDn : null;
    }
    /**
     * Set parkMonForwardNoRetrieveIntDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parkMonForwardNoRetrieveIntDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntDn) && !is_string($parkMonForwardNoRetrieveIntDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveIntDn, true), gettype($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parkMonForwardNoRetrieveIntDn) && mb_strlen($parkMonForwardNoRetrieveIntDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        if (is_null($parkMonForwardNoRetrieveIntDn) || (is_array($parkMonForwardNoRetrieveIntDn) && empty($parkMonForwardNoRetrieveIntDn))) {
            unset($this->parkMonForwardNoRetrieveIntDn);
        } else {
            $this->parkMonForwardNoRetrieveIntDn = $parkMonForwardNoRetrieveIntDn;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveVmEnabled value
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveVmEnabled) && !is_string($parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveVmEnabled, true), gettype($parkMonForwardNoRetrieveVmEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($parkMonForwardNoRetrieveVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($parkMonForwardNoRetrieveVmEnabled, true)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveVmEnabled = $parkMonForwardNoRetrieveVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveIntVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveIntVmEnabled value
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntVmEnabled) && !is_string($parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveIntVmEnabled, true), gettype($parkMonForwardNoRetrieveIntVmEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($parkMonForwardNoRetrieveIntVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($parkMonForwardNoRetrieveIntVmEnabled, true)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveIntVmEnabled = $parkMonForwardNoRetrieveIntVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return isset($this->parkMonForwardNoRetrieveCssName) ? $this->parkMonForwardNoRetrieveCssName : null;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonForwardNoRetrieveCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName = null)
    {
        if (is_null($parkMonForwardNoRetrieveCssName) || (is_array($parkMonForwardNoRetrieveCssName) && empty($parkMonForwardNoRetrieveCssName))) {
            unset($this->parkMonForwardNoRetrieveCssName);
        } else {
            $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return isset($this->parkMonForwardNoRetrieveIntCssName) ? $this->parkMonForwardNoRetrieveIntCssName : null;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        if (is_null($parkMonForwardNoRetrieveIntCssName) || (is_array($parkMonForwardNoRetrieveIntCssName) && empty($parkMonForwardNoRetrieveIntCssName))) {
            unset($this->parkMonForwardNoRetrieveIntCssName);
        } else {
            $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        }
        return $this;
    }
    /**
     * Get parkMonReversionTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonReversionTimer()
    {
        return isset($this->parkMonReversionTimer) ? $this->parkMonReversionTimer : null;
    }
    /**
     * Set parkMonReversionTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkMonReversionTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setParkMonReversionTimer($parkMonReversionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($parkMonReversionTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($parkMonReversionTimer) ? implode(', ', $parkMonReversionTimer) : var_export($parkMonReversionTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($parkMonReversionTimer) || (is_array($parkMonReversionTimer) && empty($parkMonReversionTimer))) {
            unset($this->parkMonReversionTimer);
        } else {
            $this->parkMonReversionTimer = $parkMonReversionTimer;
        }
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partyEntranceTone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setPartyEntranceTone($partyEntranceTone = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($partyEntranceTone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($partyEntranceTone) ? implode(', ', $partyEntranceTone) : var_export($partyEntranceTone, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setDirectoryURIs(\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = 'true')
    {
        // validation for constraint: string
        if (!is_null($allowCtiControlFlag) && !is_string($allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowCtiControlFlag, true), gettype($allowCtiControlFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowCtiControlFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowCtiControlFlag, true)), __LINE__);
        }
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get rejectAnonymousCall value
     * @return string|null
     */
    public function getRejectAnonymousCall()
    {
        return $this->rejectAnonymousCall;
    }
    /**
     * Set rejectAnonymousCall value
     * @param string $rejectAnonymousCall
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setRejectAnonymousCall($rejectAnonymousCall = null)
    {
        // validation for constraint: string
        if (!is_null($rejectAnonymousCall) && !is_string($rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectAnonymousCall, true), gettype($rejectAnonymousCall)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($rejectAnonymousCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($rejectAnonymousCall, true)), __LINE__);
        }
        $this->rejectAnonymousCall = $rejectAnonymousCall;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setPatternUrgency($patternUrgency = 'false')
    {
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patternUrgency, true), gettype($patternUrgency)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($patternUrgency, true)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setConfidentialAccess(\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return isset($this->externalCallControlProfile) ? $this->externalCallControlProfile : null;
    }
    /**
     * Set externalCallControlProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setExternalCallControlProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile = null)
    {
        if (is_null($externalCallControlProfile) || (is_array($externalCallControlProfile) && empty($externalCallControlProfile))) {
            unset($this->externalCallControlProfile);
        } else {
            $this->externalCallControlProfile = $externalCallControlProfile;
        }
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setEnterpriseAltNum(\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setE164AltNum(\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get pstnFailover value
     * @return string|null
     */
    public function getPstnFailover()
    {
        return $this->pstnFailover;
    }
    /**
     * Set pstnFailover value
     * @param string $pstnFailover
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setPstnFailover($pstnFailover = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailover) && !is_string($pstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailover, true), gettype($pstnFailover)), __LINE__);
        }
        $this->pstnFailover = $pstnFailover;
        return $this;
    }
    /**
     * Get callControlAgentProfile value
     * @return string|null
     */
    public function getCallControlAgentProfile()
    {
        return $this->callControlAgentProfile;
    }
    /**
     * Set callControlAgentProfile value
     * @param string $callControlAgentProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setCallControlAgentProfile($callControlAgentProfile = null)
    {
        // validation for constraint: string
        if (!is_null($callControlAgentProfile) && !is_string($callControlAgentProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callControlAgentProfile, true), gettype($callControlAgentProfile)), __LINE__);
        }
        $this->callControlAgentProfile = $callControlAgentProfile;
        return $this;
    }
    /**
     * Get useEnterpriseAltNum value
     * @return string|null
     */
    public function getUseEnterpriseAltNum()
    {
        return $this->useEnterpriseAltNum;
    }
    /**
     * Set useEnterpriseAltNum value
     * @param string $useEnterpriseAltNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setUseEnterpriseAltNum($useEnterpriseAltNum = null)
    {
        // validation for constraint: string
        if (!is_null($useEnterpriseAltNum) && !is_string($useEnterpriseAltNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useEnterpriseAltNum, true), gettype($useEnterpriseAltNum)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useEnterpriseAltNum) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useEnterpriseAltNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useEnterpriseAltNum, true)), __LINE__);
        }
        $this->useEnterpriseAltNum = $useEnterpriseAltNum;
        return $this;
    }
    /**
     * Get useE164AltNum value
     * @return string|null
     */
    public function getUseE164AltNum()
    {
        return $this->useE164AltNum;
    }
    /**
     * Set useE164AltNum value
     * @param string $useE164AltNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setUseE164AltNum($useE164AltNum = null)
    {
        // validation for constraint: string
        if (!is_null($useE164AltNum) && !is_string($useE164AltNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useE164AltNum, true), gettype($useE164AltNum)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useE164AltNum) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useE164AltNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useE164AltNum, true)), __LINE__);
        }
        $this->useE164AltNum = $useE164AltNum;
        return $this;
    }
    /**
     * Get active value
     * @return string|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLine
     */
    public function setActive($active = 'true')
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($active) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($active, true)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
}
