<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XH323Line StructType
 * @subpackage Structs
 */
class XH323Line extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XDirn
     */
    public $dirn;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $display;
    /**
     * The displayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $e164Mask;
    /**
     * The maxNumCalls
     * Meta information extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - default: Call Recording Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - default: General
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XH323Line
     * @uses XH323Line::setIndex()
     * @uses XH323Line::setDirn()
     * @uses XH323Line::setLabel()
     * @uses XH323Line::setAsciiLabel()
     * @uses XH323Line::setDisplay()
     * @uses XH323Line::setDisplayAscii()
     * @uses XH323Line::setE164Mask()
     * @uses XH323Line::setMaxNumCalls()
     * @uses XH323Line::setBusyTrigger()
     * @uses XH323Line::setCallInfoDisplay()
     * @uses XH323Line::setRecordingProfileName()
     * @uses XH323Line::setMonitoringCssName()
     * @uses XH323Line::setRecordingFlag()
     * @uses XH323Line::setAudibleMwi()
     * @uses XH323Line::setSpeedDial()
     * @uses XH323Line::setPartitionUsage()
     * @uses XH323Line::setAssociatedEndusers()
     * @uses XH323Line::setCtiid()
     * @param string $index
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @param int $ctiid
     */
    public function __construct($index = null, \Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn = null, $label = null, $asciiLabel = null, $display = null, $displayAscii = null, $e164Mask = null, $maxNumCalls = '2', $busyTrigger = '1', \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null, $recordingFlag = 'Call Recording Disabled', $audibleMwi = 'Default', $speedDial = null, $partitionUsage = 'General', \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setDirn($dirn)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get dirn value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XDirn
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setDirn(\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiLabel, true), gettype($asciiLabel)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($asciiLabel) && mb_strlen($asciiLabel) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($display) && mb_strlen($display) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayAscii, true), gettype($displayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($displayAscii) && mb_strlen($displayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getE164Mask()
    {
        return isset($this->e164Mask) ? $this->e164Mask : null;
    }
    /**
     * Set e164Mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $e164Mask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Mask, true), gettype($e164Mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($e164Mask) && mb_strlen($e164Mask) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($e164Mask)), __LINE__);
        }
        if (is_null($e164Mask) || (is_array($e164Mask) && empty($e164Mask))) {
            unset($this->e164Mask);
        } else {
            $this->e164Mask = $e164Mask;
        }
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setMaxNumCalls($maxNumCalls = '2')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxNumCalls) ? implode(', ', $maxNumCalls) : var_export($maxNumCalls, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setBusyTrigger($busyTrigger = '1')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($busyTrigger) ? implode(', ', $busyTrigger) : var_export($busyTrigger, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setCallInfoDisplay(\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return isset($this->recordingProfileName) ? $this->recordingProfileName : null;
    }
    /**
     * Set recordingProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setRecordingProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null)
    {
        if (is_null($recordingProfileName) || (is_array($recordingProfileName) && empty($recordingProfileName))) {
            unset($this->recordingProfileName);
        } else {
            $this->recordingProfileName = $recordingProfileName;
        }
        return $this;
    }
    /**
     * Get monitoringCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return isset($this->monitoringCssName) ? $this->monitoringCssName : null;
    }
    /**
     * Set monitoringCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setMonitoringCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null)
    {
        if (is_null($monitoringCssName) || (is_array($monitoringCssName) && empty($monitoringCssName))) {
            unset($this->monitoringCssName);
        } else {
            $this->monitoringCssName = $monitoringCssName;
        }
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setRecordingFlag($recordingFlag = 'Call Recording Disabled')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag', is_array($recordingFlag) ? implode(', ', $recordingFlag) : var_export($recordingFlag, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setAudibleMwi($audibleMwi = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($audibleMwi) ? implode(', ', $audibleMwi) : var_export($audibleMwi, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpeedDial()
    {
        return isset($this->speedDial) ? $this->speedDial : null;
    }
    /**
     * Set speedDial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $speedDial
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speedDial, true), gettype($speedDial)), __LINE__);
        }
        if (is_null($speedDial) || (is_array($speedDial) && empty($speedDial))) {
            unset($this->speedDial);
        } else {
            $this->speedDial = $speedDial;
        }
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setAssociatedEndusers(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
}
