<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCommonPhoneConfig StructType
 * @subpackage Structs
 */
class XCommonPhoneConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The unlockPwd
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unlockPwd;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndAlertingType
     * Meta information extracted from the WSDL
     * - default: Beep Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndAlertingType;
    /**
     * The backgroundImage
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $backgroundImage;
    /**
     * The phonePersonalization
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phonePersonalization;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The sshUserId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sshPwd;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The vpnGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnGroupName;
    /**
     * The vpnProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnProfileName;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The wifiHotspotProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wifiHotspotProfile;
    /**
     * Constructor method for XCommonPhoneConfig
     * @uses XCommonPhoneConfig::setName()
     * @uses XCommonPhoneConfig::setDescription()
     * @uses XCommonPhoneConfig::setUnlockPwd()
     * @uses XCommonPhoneConfig::setDndOption()
     * @uses XCommonPhoneConfig::setDndAlertingType()
     * @uses XCommonPhoneConfig::setBackgroundImage()
     * @uses XCommonPhoneConfig::setPhonePersonalization()
     * @uses XCommonPhoneConfig::setPhoneServiceDisplay()
     * @uses XCommonPhoneConfig::setSshUserId()
     * @uses XCommonPhoneConfig::setSshPwd()
     * @uses XCommonPhoneConfig::setVendorConfig()
     * @uses XCommonPhoneConfig::setAlwaysUsePrimeLine()
     * @uses XCommonPhoneConfig::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XCommonPhoneConfig::setVpnGroupName()
     * @uses XCommonPhoneConfig::setVpnProfileName()
     * @uses XCommonPhoneConfig::setFeatureControlPolicy()
     * @uses XCommonPhoneConfig::setWifiHotspotProfile()
     * @param string $name
     * @param string $description
     * @param string $unlockPwd
     * @param string $dndOption
     * @param string $dndAlertingType
     * @param string $backgroundImage
     * @param string $phonePersonalization
     * @param string $phoneServiceDisplay
     * @param string $sshUserId
     * @param string $sshPwd
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     */
    public function __construct($name = null, $description = null, $unlockPwd = null, $dndOption = 'Ringer Off', $dndAlertingType = 'Beep Only', $backgroundImage = 'true', $phonePersonalization = 'Default', $phoneServiceDisplay = 'Default', $sshUserId = null, $sshPwd = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setUnlockPwd($unlockPwd)
            ->setDndOption($dndOption)
            ->setDndAlertingType($dndAlertingType)
            ->setBackgroundImage($backgroundImage)
            ->setPhonePersonalization($phonePersonalization)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setVendorConfig($vendorConfig)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setVpnGroupName($vpnGroupName)
            ->setVpnProfileName($vpnProfileName)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setWifiHotspotProfile($wifiHotspotProfile);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get unlockPwd value
     * @return string|null
     */
    public function getUnlockPwd()
    {
        return $this->unlockPwd;
    }
    /**
     * Set unlockPwd value
     * @param string $unlockPwd
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setUnlockPwd($unlockPwd = null)
    {
        // validation for constraint: string
        if (!is_null($unlockPwd) && !is_string($unlockPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unlockPwd, true), gettype($unlockPwd)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($unlockPwd) && mb_strlen($unlockPwd) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($unlockPwd)), __LINE__);
        }
        $this->unlockPwd = $unlockPwd;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption', is_array($dndOption) ? implode(', ', $dndOption) : var_export($dndOption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndAlertingType value
     * @return string|null
     */
    public function getDndAlertingType()
    {
        return $this->dndAlertingType;
    }
    /**
     * Set dndAlertingType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndAlertingType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setDndAlertingType($dndAlertingType = 'Beep Only')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($dndAlertingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($dndAlertingType) ? implode(', ', $dndAlertingType) : var_export($dndAlertingType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndAlertingType = $dndAlertingType;
        return $this;
    }
    /**
     * Get backgroundImage value
     * @return string|null
     */
    public function getBackgroundImage()
    {
        return $this->backgroundImage;
    }
    /**
     * Set backgroundImage value
     * @param string $backgroundImage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setBackgroundImage($backgroundImage = 'true')
    {
        // validation for constraint: string
        if (!is_null($backgroundImage) && !is_string($backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundImage, true), gettype($backgroundImage)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($backgroundImage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($backgroundImage, true)), __LINE__);
        }
        $this->backgroundImage = $backgroundImage;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setPhonePersonalization($phonePersonalization = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization', is_array($phonePersonalization) ? implode(', ', $phonePersonalization) : var_export($phonePersonalization, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay', is_array($phoneServiceDisplay) ? implode(', ', $phoneServiceDisplay) : var_export($phoneServiceDisplay, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sshUserId, true), gettype($sshUserId)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sshUserId) && mb_strlen($sshUserId) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setSshPwd($sshPwd = null)
    {
        // validation for constraint: string
        if (!is_null($sshPwd) && !is_string($sshPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sshPwd, true), gettype($sshPwd)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($sshPwd) && mb_strlen($sshPwd) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($sshPwd)), __LINE__);
        }
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setVendorConfig(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLine) ? implode(', ', $alwaysUsePrimeLine) : var_export($alwaysUsePrimeLine, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLineForVoiceMessage) ? implode(', ', $alwaysUsePrimeLineForVoiceMessage) : var_export($alwaysUsePrimeLineForVoiceMessage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get vpnGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnGroupName()
    {
        return isset($this->vpnGroupName) ? $this->vpnGroupName : null;
    }
    /**
     * Set vpnGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setVpnGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName = null)
    {
        if (is_null($vpnGroupName) || (is_array($vpnGroupName) && empty($vpnGroupName))) {
            unset($this->vpnGroupName);
        } else {
            $this->vpnGroupName = $vpnGroupName;
        }
        return $this;
    }
    /**
     * Get vpnProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnProfileName()
    {
        return isset($this->vpnProfileName) ? $this->vpnProfileName : null;
    }
    /**
     * Set vpnProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setVpnProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName = null)
    {
        if (is_null($vpnProfileName) || (is_array($vpnProfileName) && empty($vpnProfileName))) {
            unset($this->vpnProfileName);
        } else {
            $this->vpnProfileName = $vpnProfileName;
        }
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setFeatureControlPolicy(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return isset($this->wifiHotspotProfile) ? $this->wifiHotspotProfile : null;
    }
    /**
     * Set wifiHotspotProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCommonPhoneConfig
     */
    public function setWifiHotspotProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null)
    {
        if (is_null($wifiHotspotProfile) || (is_array($wifiHotspotProfile) && empty($wifiHotspotProfile))) {
            unset($this->wifiHotspotProfile);
        } else {
            $this->wifiHotspotProfile = $wifiHotspotProfile;
        }
        return $this;
    }
}
