<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallForwardBusy StructType
 * @subpackage Structs
 */
class XCallForwardBusy extends AbstractStructBase
{
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The forwardToVoiceMail
     * Meta information extracted from the WSDL
     * - documentation: DB: Derived from CF*VoiceMailEnabled fields. This tag has been marked as ReadOnly for callForwardAlternateParty as it is not applicable for callForwardAlternateParty setting.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $destination;
    /**
     * Constructor method for XCallForwardBusy
     * @uses XCallForwardBusy::setCallingSearchSpaceName()
     * @uses XCallForwardBusy::setForwardToVoiceMail()
     * @uses XCallForwardBusy::setDestination()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param string $forwardToVoiceMail
     * @param string $destination
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, $forwardToVoiceMail = null, $destination = null)
    {
        $this
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setDestination($destination);
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardToVoiceMail, true), gettype($forwardToVoiceMail)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * Set destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallForwardBusy
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($destination) && mb_strlen($destination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
}
