<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XBillingServer StructType
 * @subpackage Structs
 */
class XBillingServer extends AbstractStructBase
{
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostName;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The directory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $directory;
    /**
     * The billingServerProtocol
     * Meta information extracted from the WSDL
     * - default: SFTP
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $billingServerProtocol;
    /**
     * The resendOnFailure
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $resendOnFailure;
    /**
     * Constructor method for XBillingServer
     * @uses XBillingServer::setHostName()
     * @uses XBillingServer::setUserId()
     * @uses XBillingServer::setPassword()
     * @uses XBillingServer::setDirectory()
     * @uses XBillingServer::setBillingServerProtocol()
     * @uses XBillingServer::setResendOnFailure()
     * @param string $hostName
     * @param string $userId
     * @param string $password
     * @param string $directory
     * @param string $billingServerProtocol
     * @param string $resendOnFailure
     */
    public function __construct($hostName = null, $userId = null, $password = null, $directory = null, $billingServerProtocol = 'SFTP', $resendOnFailure = 'true')
    {
        $this
            ->setHostName($hostName)
            ->setUserId($userId)
            ->setPassword($password)
            ->setDirectory($directory)
            ->setBillingServerProtocol($billingServerProtocol)
            ->setResendOnFailure($resendOnFailure);
    }
    /**
     * Get hostName value
     * @return string
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostName, true), gettype($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get directory value
     * @return string
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: string
        if (!is_null($directory) && !is_string($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directory, true), gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get billingServerProtocol value
     * @return string
     */
    public function getBillingServerProtocol()
    {
        return $this->billingServerProtocol;
    }
    /**
     * Set billingServerProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingServerProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setBillingServerProtocol($billingServerProtocol = 'SFTP')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::valueIsValid($billingServerProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol', is_array($billingServerProtocol) ? implode(', ', $billingServerProtocol) : var_export($billingServerProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::getValidValues())), __LINE__);
        }
        $this->billingServerProtocol = $billingServerProtocol;
        return $this;
    }
    /**
     * Get resendOnFailure value
     * @return string|null
     */
    public function getResendOnFailure()
    {
        return $this->resendOnFailure;
    }
    /**
     * Set resendOnFailure value
     * @param string $resendOnFailure
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setResendOnFailure($resendOnFailure = 'true')
    {
        // validation for constraint: string
        if (!is_null($resendOnFailure) && !is_string($resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resendOnFailure, true), gettype($resendOnFailure)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($resendOnFailure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($resendOnFailure, true)), __LINE__);
        }
        $this->resendOnFailure = $resendOnFailure;
        return $this;
    }
}
