<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAssignedPresenceUsers StructType
 * @subpackage Structs
 */
class XAssignedPresenceUsers extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The server
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $server;
    /**
     * The presenceRedundancyGroup
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $presenceRedundancyGroup;
    /**
     * Constructor method for XAssignedPresenceUsers
     * @uses XAssignedPresenceUsers::setUserid()
     * @uses XAssignedPresenceUsers::setServer()
     * @uses XAssignedPresenceUsers::setPresenceRedundancyGroup()
     * @param string $userid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server
     * @param string $presenceRedundancyGroup
     */
    public function __construct($userid = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server = null, $presenceRedundancyGroup = null)
    {
        $this
            ->setUserid($userid)
            ->setServer($server)
            ->setPresenceRedundancyGroup($presenceRedundancyGroup);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAssignedPresenceUsers
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get server value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServer()
    {
        return isset($this->server) ? $this->server : null;
    }
    /**
     * Set server value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAssignedPresenceUsers
     */
    public function setServer(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $server = null)
    {
        if (is_null($server) || (is_array($server) && empty($server))) {
            unset($this->server);
        } else {
            $this->server = $server;
        }
        return $this;
    }
    /**
     * Get presenceRedundancyGroup value
     * @return string|null
     */
    public function getPresenceRedundancyGroup()
    {
        return $this->presenceRedundancyGroup;
    }
    /**
     * Set presenceRedundancyGroup value
     * @param string $presenceRedundancyGroup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAssignedPresenceUsers
     */
    public function setPresenceRedundancyGroup($presenceRedundancyGroup = null)
    {
        // validation for constraint: string
        if (!is_null($presenceRedundancyGroup) && !is_string($presenceRedundancyGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presenceRedundancyGroup, true), gettype($presenceRedundancyGroup)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($presenceRedundancyGroup) && mb_strlen($presenceRedundancyGroup) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($presenceRedundancyGroup)), __LINE__);
        }
        $this->presenceRedundancyGroup = $presenceRedundancyGroup;
        return $this;
    }
}
