<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationServer StructType
 * @subpackage Structs
 */
class XApplicationServer extends AbstractStructBase
{
    /**
     * The appServerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $appServerType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The appUsers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The endUsers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\EndUsers
     */
    public $endUsers;
    /**
     * Constructor method for XApplicationServer
     * @uses XApplicationServer::setAppServerType()
     * @uses XApplicationServer::setName()
     * @uses XApplicationServer::setIpAddress()
     * @uses XApplicationServer::setAppUsers()
     * @uses XApplicationServer::setUrl()
     * @uses XApplicationServer::setEndUserUrl()
     * @uses XApplicationServer::setProcessNodeName()
     * @uses XApplicationServer::setEndUsers()
     * @param string $appServerType
     * @param string $name
     * @param string $ipAddress
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers
     */
    public function __construct($appServerType = null, $name = null, $ipAddress = null, \Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers = null, $url = null, $endUserUrl = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, \Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers = null)
    {
        $this
            ->setAppServerType($appServerType)
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setEndUsers($endUsers);
    }
    /**
     * Get appServerType value
     * @return string
     */
    public function getAppServerType()
    {
        return $this->appServerType;
    }
    /**
     * Set appServerType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAppServer::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAppServer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setAppServerType($appServerType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAppServer::valueIsValid($appServerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAppServer', is_array($appServerType) ? implode(', ', $appServerType) : var_export($appServerType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAppServer::getValidValues())), __LINE__);
        }
        $this->appServerType = $appServerType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get appUsers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AppUsers|null
     */
    public function getAppUsers()
    {
        return $this->appUsers;
    }
    /**
     * Set appUsers value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setAppUsers(\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers = null)
    {
        $this->appUsers = $appUsers;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endUserUrl) && !is_string($endUserUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endUserUrl, true), gettype($endUserUrl)), __LINE__);
        }
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * Set processNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setProcessNodeName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get endUsers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\EndUsers|null
     */
    public function getEndUsers()
    {
        return $this->endUsers;
    }
    /**
     * Set endUsers value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationServer
     */
    public function setEndUsers(\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers = null)
    {
        $this->endUsers = $endUsers;
        return $this;
    }
}
