<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationDialRules StructType
 * @subpackage Structs
 */
class XApplicationDialRules extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The numberOfDigits
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $numberOfDigits;
    /**
     * The digitsToBeRemoved
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $digitsToBeRemoved;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $priority;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The numberBeginWith
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberBeginWith;
    /**
     * The prefixPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefixPattern;
    /**
     * Constructor method for XApplicationDialRules
     * @uses XApplicationDialRules::setName()
     * @uses XApplicationDialRules::setNumberOfDigits()
     * @uses XApplicationDialRules::setDigitsToBeRemoved()
     * @uses XApplicationDialRules::setPriority()
     * @uses XApplicationDialRules::setDescription()
     * @uses XApplicationDialRules::setNumberBeginWith()
     * @uses XApplicationDialRules::setPrefixPattern()
     * @param string $name
     * @param string $numberOfDigits
     * @param string $digitsToBeRemoved
     * @param string $priority
     * @param string $description
     * @param string $numberBeginWith
     * @param string $prefixPattern
     */
    public function __construct($name = null, $numberOfDigits = '0', $digitsToBeRemoved = '0', $priority = '0', $description = null, $numberBeginWith = null, $prefixPattern = null)
    {
        $this
            ->setName($name)
            ->setNumberOfDigits($numberOfDigits)
            ->setDigitsToBeRemoved($digitsToBeRemoved)
            ->setPriority($priority)
            ->setDescription($description)
            ->setNumberBeginWith($numberBeginWith)
            ->setPrefixPattern($prefixPattern);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get numberOfDigits value
     * @return string
     */
    public function getNumberOfDigits()
    {
        return $this->numberOfDigits;
    }
    /**
     * Set numberOfDigits value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setNumberOfDigits($numberOfDigits = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numberOfDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numberOfDigits) ? implode(', ', $numberOfDigits) : var_export($numberOfDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigits = $numberOfDigits;
        return $this;
    }
    /**
     * Get digitsToBeRemoved value
     * @return string
     */
    public function getDigitsToBeRemoved()
    {
        return $this->digitsToBeRemoved;
    }
    /**
     * Set digitsToBeRemoved value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitsToBeRemoved
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setDigitsToBeRemoved($digitsToBeRemoved = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($digitsToBeRemoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($digitsToBeRemoved) ? implode(', ', $digitsToBeRemoved) : var_export($digitsToBeRemoved, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->digitsToBeRemoved = $digitsToBeRemoved;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setPriority($priority = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberBeginWith value
     * @return string|null
     */
    public function getNumberBeginWith()
    {
        return $this->numberBeginWith;
    }
    /**
     * Set numberBeginWith value
     * @param string $numberBeginWith
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setNumberBeginWith($numberBeginWith = null)
    {
        // validation for constraint: string
        if (!is_null($numberBeginWith) && !is_string($numberBeginWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberBeginWith, true), gettype($numberBeginWith)), __LINE__);
        }
        $this->numberBeginWith = $numberBeginWith;
        return $this;
    }
    /**
     * Get prefixPattern value
     * @return string|null
     */
    public function getPrefixPattern()
    {
        return $this->prefixPattern;
    }
    /**
     * Set prefixPattern value
     * @param string $prefixPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationDialRules
     */
    public function setPrefixPattern($prefixPattern = null)
    {
        // validation for constraint: string
        if (!is_null($prefixPattern) && !is_string($prefixPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixPattern, true), gettype($prefixPattern)), __LINE__);
        }
        $this->prefixPattern = $prefixPattern;
        return $this;
    }
}
