<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAnalogPort StructType
 * @subpackage Structs
 */
class XAnalogPort extends AbstractStructBase
{
    /**
     * The portNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $portNumber;
    /**
     * The callerIdEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerIdEnable;
    /**
     * The expectedDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expectedDigits;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The smdiPortNumber
     * Meta information extracted from the WSDL
     * - documentation: Not used by T1 Ports
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $smdiPortNumber;
    /**
     * The trunkDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trunkDirection;
    /**
     * The timer1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timer1;
    /**
     * The timer2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timer2;
    /**
     * The timer3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timer3;
    /**
     * The timer4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timer4;
    /**
     * The timer5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timer5;
    /**
     * The timer6
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timer6;
    /**
     * The attendantDn
     * Meta information extracted from the WSDL
     * - documentation: Mandatory for ground start and loop start
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attendantDn;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The digitSending
     * Meta information extracted from the WSDL
     * - default: DTMF
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefixDn;
    /**
     * The presentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presentationBit;
    /**
     * The silenceSuppressionThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $silenceSuppressionThreshold;
    /**
     * The startDialProtocol
     * Meta information extracted from the WSDL
     * - default: Not Set
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDialProtocol;
    /**
     * The trunk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunk;
    /**
     * The trunkLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkLevel;
    /**
     * The trunkPadRx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadRx;
    /**
     * The trunkPadTx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadTx;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: Arbitrary XML defined by 3rd party vendors.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * Constructor method for XAnalogPort
     * @uses XAnalogPort::setPortNumber()
     * @uses XAnalogPort::setCallerIdEnable()
     * @uses XAnalogPort::setExpectedDigits()
     * @uses XAnalogPort::setSigDigits()
     * @uses XAnalogPort::setSmdiPortNumber()
     * @uses XAnalogPort::setTrunkDirection()
     * @uses XAnalogPort::setTimer1()
     * @uses XAnalogPort::setTimer2()
     * @uses XAnalogPort::setTimer3()
     * @uses XAnalogPort::setTimer4()
     * @uses XAnalogPort::setTimer5()
     * @uses XAnalogPort::setTimer6()
     * @uses XAnalogPort::setAttendantDn()
     * @uses XAnalogPort::setUnattendedPort()
     * @uses XAnalogPort::setCallerIdDn()
     * @uses XAnalogPort::setCallingPartySelection()
     * @uses XAnalogPort::setDigitSending()
     * @uses XAnalogPort::setLines()
     * @uses XAnalogPort::setPrefixDn()
     * @uses XAnalogPort::setPresentationBit()
     * @uses XAnalogPort::setSilenceSuppressionThreshold()
     * @uses XAnalogPort::setStartDialProtocol()
     * @uses XAnalogPort::setTrunk()
     * @uses XAnalogPort::setTrunkLevel()
     * @uses XAnalogPort::setTrunkPadRx()
     * @uses XAnalogPort::setTrunkPadTx()
     * @uses XAnalogPort::setVendorConfig()
     * @param string $portNumber
     * @param string $callerIdEnable
     * @param string $expectedDigits
     * @param \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $smdiPortNumber
     * @param string $trunkDirection
     * @param string $timer1
     * @param string $timer2
     * @param string $timer3
     * @param string $timer4
     * @param string $timer5
     * @param string $timer6
     * @param string $attendantDn
     * @param string $unattendedPort
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $digitSending
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param string $prefixDn
     * @param string $presentationBit
     * @param string $silenceSuppressionThreshold
     * @param string $startDialProtocol
     * @param string $trunk
     * @param string $trunkLevel
     * @param string $trunkPadRx
     * @param string $trunkPadTx
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     */
    public function __construct($portNumber = null, $callerIdEnable = null, $expectedDigits = null, \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $smdiPortNumber = '0', $trunkDirection = null, $timer1 = null, $timer2 = null, $timer3 = null, $timer4 = null, $timer5 = null, $timer6 = null, $attendantDn = null, $unattendedPort = null, $callerIdDn = null, $callingPartySelection = null, $digitSending = 'DTMF', \Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, $prefixDn = null, $presentationBit = null, $silenceSuppressionThreshold = null, $startDialProtocol = 'Not Set', $trunk = null, $trunkLevel = null, $trunkPadRx = null, $trunkPadTx = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this
            ->setPortNumber($portNumber)
            ->setCallerIdEnable($callerIdEnable)
            ->setExpectedDigits($expectedDigits)
            ->setSigDigits($sigDigits)
            ->setSmdiPortNumber($smdiPortNumber)
            ->setTrunkDirection($trunkDirection)
            ->setTimer1($timer1)
            ->setTimer2($timer2)
            ->setTimer3($timer3)
            ->setTimer4($timer4)
            ->setTimer5($timer5)
            ->setTimer6($timer6)
            ->setAttendantDn($attendantDn)
            ->setUnattendedPort($unattendedPort)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setDigitSending($digitSending)
            ->setLines($lines)
            ->setPrefixDn($prefixDn)
            ->setPresentationBit($presentationBit)
            ->setSilenceSuppressionThreshold($silenceSuppressionThreshold)
            ->setStartDialProtocol($startDialProtocol)
            ->setTrunk($trunk)
            ->setTrunkLevel($trunkLevel)
            ->setTrunkPadRx($trunkPadRx)
            ->setTrunkPadTx($trunkPadTx)
            ->setVendorConfig($vendorConfig);
    }
    /**
     * Get portNumber value
     * @return string
     */
    public function getPortNumber()
    {
        return $this->portNumber;
    }
    /**
     * Set portNumber value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setPortNumber($portNumber = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($portNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($portNumber) ? implode(', ', $portNumber) : var_export($portNumber, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->portNumber = $portNumber;
        return $this;
    }
    /**
     * Get callerIdEnable value
     * @return string
     */
    public function getCallerIdEnable()
    {
        return $this->callerIdEnable;
    }
    /**
     * Set callerIdEnable value
     * @param string $callerIdEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setCallerIdEnable($callerIdEnable = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdEnable) && !is_string($callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdEnable, true), gettype($callerIdEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($callerIdEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($callerIdEnable, true)), __LINE__);
        }
        $this->callerIdEnable = $callerIdEnable;
        return $this;
    }
    /**
     * Get expectedDigits value
     * @return string
     */
    public function getExpectedDigits()
    {
        return $this->expectedDigits;
    }
    /**
     * Set expectedDigits value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setExpectedDigits($expectedDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($expectedDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($expectedDigits) ? implode(', ', $expectedDigits) : var_export($expectedDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->expectedDigits = $expectedDigits;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setSigDigits(\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get smdiPortNumber value
     * @return string
     */
    public function getSmdiPortNumber()
    {
        return $this->smdiPortNumber;
    }
    /**
     * Set smdiPortNumber value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smdiPortNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setSmdiPortNumber($smdiPortNumber = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($smdiPortNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($smdiPortNumber) ? implode(', ', $smdiPortNumber) : var_export($smdiPortNumber, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->smdiPortNumber = $smdiPortNumber;
        return $this;
    }
    /**
     * Get trunkDirection value
     * @return string
     */
    public function getTrunkDirection()
    {
        return $this->trunkDirection;
    }
    /**
     * Set trunkDirection value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkDirection::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkDirection
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTrunkDirection($trunkDirection = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkDirection::valueIsValid($trunkDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkDirection', is_array($trunkDirection) ? implode(', ', $trunkDirection) : var_export($trunkDirection, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkDirection::getValidValues())), __LINE__);
        }
        $this->trunkDirection = $trunkDirection;
        return $this;
    }
    /**
     * Get timer1 value
     * @return string
     */
    public function getTimer1()
    {
        return $this->timer1;
    }
    /**
     * Set timer1 value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer1
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTimer1($timer1 = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($timer1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($timer1) ? implode(', ', $timer1) : var_export($timer1, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer1 = $timer1;
        return $this;
    }
    /**
     * Get timer2 value
     * @return string
     */
    public function getTimer2()
    {
        return $this->timer2;
    }
    /**
     * Set timer2 value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer2
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTimer2($timer2 = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($timer2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($timer2) ? implode(', ', $timer2) : var_export($timer2, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer2 = $timer2;
        return $this;
    }
    /**
     * Get timer3 value
     * @return string
     */
    public function getTimer3()
    {
        return $this->timer3;
    }
    /**
     * Set timer3 value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer3
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTimer3($timer3 = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($timer3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($timer3) ? implode(', ', $timer3) : var_export($timer3, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer3 = $timer3;
        return $this;
    }
    /**
     * Get timer4 value
     * @return string
     */
    public function getTimer4()
    {
        return $this->timer4;
    }
    /**
     * Set timer4 value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer4
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTimer4($timer4 = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($timer4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($timer4) ? implode(', ', $timer4) : var_export($timer4, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer4 = $timer4;
        return $this;
    }
    /**
     * Get timer5 value
     * @return string
     */
    public function getTimer5()
    {
        return $this->timer5;
    }
    /**
     * Set timer5 value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer5
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTimer5($timer5 = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($timer5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($timer5) ? implode(', ', $timer5) : var_export($timer5, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer5 = $timer5;
        return $this;
    }
    /**
     * Get timer6 value
     * @return string
     */
    public function getTimer6()
    {
        return $this->timer6;
    }
    /**
     * Set timer6 value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer6
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTimer6($timer6 = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($timer6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($timer6) ? implode(', ', $timer6) : var_export($timer6, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer6 = $timer6;
        return $this;
    }
    /**
     * Get attendantDn value
     * @return string|null
     */
    public function getAttendantDn()
    {
        return $this->attendantDn;
    }
    /**
     * Set attendantDn value
     * @param string $attendantDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setAttendantDn($attendantDn = null)
    {
        // validation for constraint: string
        if (!is_null($attendantDn) && !is_string($attendantDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attendantDn, true), gettype($attendantDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($attendantDn) && mb_strlen($attendantDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($attendantDn)), __LINE__);
        }
        $this->attendantDn = $attendantDn;
        return $this;
    }
    /**
     * Get unattendedPort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return isset($this->unattendedPort) ? $this->unattendedPort : null;
    }
    /**
     * Set unattendedPort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unattendedPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        if (is_null($unattendedPort) || (is_array($unattendedPort) && empty($unattendedPort))) {
            unset($this->unattendedPort);
        } else {
            $this->unattendedPort = $unattendedPort;
        }
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection', is_array($callingPartySelection) ? implode(', ', $callingPartySelection) : var_export($callingPartySelection, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setDigitSending($digitSending = 'DTMF')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending', is_array($digitSending) ? implode(', ', $digitSending) : var_export($digitSending, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get lines value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setLines(\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDn, true), gettype($prefixDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prefixDn) && mb_strlen($prefixDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($prefixDn)), __LINE__);
        }
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string|null
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setPresentationBit($presentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($presentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($presentationBit) ? implode(', ', $presentationBit) : var_export($presentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get silenceSuppressionThreshold value
     * @return string|null
     */
    public function getSilenceSuppressionThreshold()
    {
        return $this->silenceSuppressionThreshold;
    }
    /**
     * Set silenceSuppressionThreshold value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSilenceSuppressionThreshold::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSilenceSuppressionThreshold::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $silenceSuppressionThreshold
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setSilenceSuppressionThreshold($silenceSuppressionThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSilenceSuppressionThreshold::valueIsValid($silenceSuppressionThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSilenceSuppressionThreshold', is_array($silenceSuppressionThreshold) ? implode(', ', $silenceSuppressionThreshold) : var_export($silenceSuppressionThreshold, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSilenceSuppressionThreshold::getValidValues())), __LINE__);
        }
        $this->silenceSuppressionThreshold = $silenceSuppressionThreshold;
        return $this;
    }
    /**
     * Get startDialProtocol value
     * @return string|null
     */
    public function getStartDialProtocol()
    {
        return $this->startDialProtocol;
    }
    /**
     * Set startDialProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStartDialProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStartDialProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDialProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setStartDialProtocol($startDialProtocol = 'Not Set')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStartDialProtocol::valueIsValid($startDialProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStartDialProtocol', is_array($startDialProtocol) ? implode(', ', $startDialProtocol) : var_export($startDialProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStartDialProtocol::getValidValues())), __LINE__);
        }
        $this->startDialProtocol = $startDialProtocol;
        return $this;
    }
    /**
     * Get trunk value
     * @return string|null
     */
    public function getTrunk()
    {
        return $this->trunk;
    }
    /**
     * Set trunk value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunk::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunk::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunk
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTrunk($trunk = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunk::valueIsValid($trunk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunk', is_array($trunk) ? implode(', ', $trunk) : var_export($trunk, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunk::getValidValues())), __LINE__);
        }
        $this->trunk = $trunk;
        return $this;
    }
    /**
     * Get trunkLevel value
     * @return string|null
     */
    public function getTrunkLevel()
    {
        return $this->trunkLevel;
    }
    /**
     * Set trunkLevel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkLevel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTrunkLevel($trunkLevel = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkLevel::valueIsValid($trunkLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkLevel', is_array($trunkLevel) ? implode(', ', $trunkLevel) : var_export($trunkLevel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkLevel::getValidValues())), __LINE__);
        }
        $this->trunkLevel = $trunkLevel;
        return $this;
    }
    /**
     * Get trunkPadRx value
     * @return string|null
     */
    public function getTrunkPadRx()
    {
        return $this->trunkPadRx;
    }
    /**
     * Set trunkPadRx value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadRx
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTrunkPadRx($trunkPadRx = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::valueIsValid($trunkPadRx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad', is_array($trunkPadRx) ? implode(', ', $trunkPadRx) : var_export($trunkPadRx, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadRx = $trunkPadRx;
        return $this;
    }
    /**
     * Get trunkPadTx value
     * @return string|null
     */
    public function getTrunkPadTx()
    {
        return $this->trunkPadTx;
    }
    /**
     * Set trunkPadTx value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadTx
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setTrunkPadTx($trunkPadTx = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::valueIsValid($trunkPadTx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad', is_array($trunkPadTx) ? implode(', ', $trunkPadTx) : var_export($trunkPadTx, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadTx = $trunkPadTx;
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort
     */
    public function setVendorConfig(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
}
