<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userGroup StructType
 * @subpackage Structs
 */
class UserGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name of User Group
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The userRoles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\UserRoles
     */
    public $userRoles;
    /**
     * Constructor method for userGroup
     * @uses UserGroup::setName()
     * @uses UserGroup::setUserRoles()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles = null)
    {
        $this
            ->setName($name)
            ->setUserRoles($userRoles);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UserGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name) && mb_strlen($name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get userRoles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UserRoles|null
     */
    public function getUserRoles()
    {
        return $this->userRoles;
    }
    /**
     * Set userRoles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UserGroup
     */
    public function setUserRoles(\Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles = null)
    {
        $this->userRoles = $userRoles;
        return $this;
    }
}
