<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoiceMailPortReq StructType
 * @subpackage Structs
 */
class UpdateVoiceMailPortReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The dnPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dnPattern;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartition;
    /**
     * The dnCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dnCallingSearchSpace;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callerIdDisplay
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callerIdDisplay;
    /**
     * The callerIdDisplayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callerIdDisplayAscii;
    /**
     * The externalMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalMask;
    /**
     * Constructor method for UpdateVoiceMailPortReq
     * @uses UpdateVoiceMailPortReq::setNewName()
     * @uses UpdateVoiceMailPortReq::setDescription()
     * @uses UpdateVoiceMailPortReq::setCallingSearchSpaceName()
     * @uses UpdateVoiceMailPortReq::setDevicePoolName()
     * @uses UpdateVoiceMailPortReq::setCommonDeviceConfigName()
     * @uses UpdateVoiceMailPortReq::setLocationName()
     * @uses UpdateVoiceMailPortReq::setUseTrustedRelayPoint()
     * @uses UpdateVoiceMailPortReq::setSecurityProfileName()
     * @uses UpdateVoiceMailPortReq::setGeoLocationName()
     * @uses UpdateVoiceMailPortReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateVoiceMailPortReq::setDnPattern()
     * @uses UpdateVoiceMailPortReq::setRoutePartition()
     * @uses UpdateVoiceMailPortReq::setDnCallingSearchSpace()
     * @uses UpdateVoiceMailPortReq::setAarNeighborhoodName()
     * @uses UpdateVoiceMailPortReq::setCallerIdDisplay()
     * @uses UpdateVoiceMailPortReq::setCallerIdDisplayAscii()
     * @uses UpdateVoiceMailPortReq::setExternalMask()
     * @param string $newName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $useTrustedRelayPoint
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param string $dnPattern
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $callerIdDisplay
     * @param string $callerIdDisplayAscii
     * @param string $externalMask
     */
    public function __construct($newName = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $useTrustedRelayPoint = 'Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, $dnPattern = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $callerIdDisplay = null, $callerIdDisplayAscii = null, $externalMask = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setGeoLocationName($geoLocationName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setDnPattern($dnPattern)
            ->setRoutePartition($routePartition)
            ->setDnCallingSearchSpace($dnCallingSearchSpace)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallerIdDisplay($callerIdDisplay)
            ->setCallerIdDisplayAscii($callerIdDisplayAscii)
            ->setExternalMask($externalMask);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($newName) && mb_strlen($newName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setSecurityProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setGeoLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setAutomatedAlternateRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get dnPattern value
     * @return string|null
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setDnPattern($dnPattern = null)
    {
        // validation for constraint: string
        if (!is_null($dnPattern) && !is_string($dnPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnPattern, true), gettype($dnPattern)), __LINE__);
        }
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get routePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * Set routePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setRoutePartition(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition = null)
    {
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get dnCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDnCallingSearchSpace()
    {
        return isset($this->dnCallingSearchSpace) ? $this->dnCallingSearchSpace : null;
    }
    /**
     * Set dnCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setDnCallingSearchSpace(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace = null)
    {
        if (is_null($dnCallingSearchSpace) || (is_array($dnCallingSearchSpace) && empty($dnCallingSearchSpace))) {
            unset($this->dnCallingSearchSpace);
        } else {
            $this->dnCallingSearchSpace = $dnCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get callerIdDisplay value
     * @return string|null
     */
    public function getCallerIdDisplay()
    {
        return $this->callerIdDisplay;
    }
    /**
     * Set callerIdDisplay value
     * @param string $callerIdDisplay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setCallerIdDisplay($callerIdDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDisplay) && !is_string($callerIdDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDisplay, true), gettype($callerIdDisplay)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callerIdDisplay) && mb_strlen($callerIdDisplay) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callerIdDisplay)), __LINE__);
        }
        $this->callerIdDisplay = $callerIdDisplay;
        return $this;
    }
    /**
     * Get callerIdDisplayAscii value
     * @return string|null
     */
    public function getCallerIdDisplayAscii()
    {
        return $this->callerIdDisplayAscii;
    }
    /**
     * Set callerIdDisplayAscii value
     * @param string $callerIdDisplayAscii
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setCallerIdDisplayAscii($callerIdDisplayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDisplayAscii) && !is_string($callerIdDisplayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDisplayAscii, true), gettype($callerIdDisplayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDisplayAscii) && mb_strlen($callerIdDisplayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDisplayAscii)), __LINE__);
        }
        $this->callerIdDisplayAscii = $callerIdDisplayAscii;
        return $this;
    }
    /**
     * Get externalMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalMask()
    {
        return isset($this->externalMask) ? $this->externalMask : null;
    }
    /**
     * Set externalMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq
     */
    public function setExternalMask($externalMask = null)
    {
        // validation for constraint: string
        if (!is_null($externalMask) && !is_string($externalMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalMask, true), gettype($externalMask)), __LINE__);
        }
        if (is_null($externalMask) || (is_array($externalMask) && empty($externalMask))) {
            unset($this->externalMask);
        } else {
            $this->externalMask = $externalMask;
        }
        return $this;
    }
}
