<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserReq StructType
 * @subpackage Structs
 */
class UpdateUserReq extends APIRequest
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - choice: uuid | userid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | userid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lastName;
    /**
     * The newUserid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newUserid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The mailid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mailid;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $department;
    /**
     * The manager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $manager;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The primaryExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension
     */
    public $primaryExtension;
    /**
     * The associatedPc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $associatedPc;
    /**
     * The associatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The enableCti
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCti;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $digestCredentials;
    /**
     * The phoneProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles
     */
    public $phoneProfiles;
    /**
     * The defaultProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultProfile;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The enableMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWaitTime
     * Meta information extracted from the WSDL
     * - documentation: Maximum wait time for Desk Pickup must be a number in the range 0 to 30000.Not Nullable.
     * - default: 10000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxDeskPickupWaitTime;
    /**
     * The remoteDestinationLimit
     * Meta information extracted from the WSDL
     * - documentation: Remote Destination Limit must be a number in the range 1 to 10. Not Nullable.
     * - default: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The passwordCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The pinCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials
     */
    public $pinCredentials;
    /**
     * The primaryDevice
     * Meta information extracted from the WSDL
     * - documentation: Primary Device for mobility users
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryDevice;
    /**
     * The enableEmcc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEmcc;
    /**
     * The ctiControlledDeviceProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The numericUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numericUserId;
    /**
     * The mlppPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppPassword;
    /**
     * The customUserFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields
     */
    public $customUserFields;
    /**
     * The homeCluster
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndPresenceEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndPresenceEnable;
    /**
     * The serviceProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $serviceProfile;
    /**
     * The lineAppearanceAssociationForPresences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences
     */
    public $lineAppearanceAssociationForPresences;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $directoryUri;
    /**
     * The telephoneNumber
     * Meta information extracted from the WSDL
     * - documentation: This field also corresponds to the field 'Number Displayed in Directory' for the Quick User/phone Add page.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $telephoneNumber;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $title;
    /**
     * The mobileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mobileNumber;
    /**
     * The homeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $homeNumber;
    /**
     * The pagerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pagerNumber;
    /**
     * The removeExtensionsInfo
     * Meta information extracted from the WSDL
     * - choice: removeExtensionsInfo | addExtensionsInfo | extensionsInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveExtensionsInfo
     */
    public $removeExtensionsInfo;
    /**
     * The addExtensionsInfo
     * Meta information extracted from the WSDL
     * - choice: removeExtensionsInfo | addExtensionsInfo | extensionsInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddExtensionsInfo
     */
    public $addExtensionsInfo;
    /**
     * The extensionsInfo
     * Meta information extracted from the WSDL
     * - choice: removeExtensionsInfo | addExtensionsInfo | extensionsInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo
     */
    public $extensionsInfo;
    /**
     * The selfService
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $selfService;
    /**
     * The userProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $userProfile;
    /**
     * The calendarPresence
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $calendarPresence;
    /**
     * The ldapDirectoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ldapDirectoryName;
    /**
     * The userIdentity
     * Meta information extracted from the WSDL
     * - documentation: Value should be of of the format user@domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userIdentity;
    /**
     * The nameDialing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nameDialing;
    /**
     * The ipccExtension
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Controlled Devices so this tag is appropriate for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ipccExtension;
    /**
     * The convertUserAccount
     * Meta information extracted from the WSDL
     * - documentation: These tags are for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $convertUserAccount;
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies this is a Locally created user and a value of 'LDAP' implies this user is an LDAP Synchronized user
     * - default: Local
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountType;
    /**
     * The authenticationType
     * Meta information extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies authentication will happen at CUCM and a value of 'LDAP' implies authentication will happen at the LDAP
     * - default: Local
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationType;
    /**
     * Constructor method for UpdateUserReq
     * @uses UpdateUserReq::setUserid()
     * @uses UpdateUserReq::setUuid()
     * @uses UpdateUserReq::setFirstName()
     * @uses UpdateUserReq::setMiddleName()
     * @uses UpdateUserReq::setLastName()
     * @uses UpdateUserReq::setNewUserid()
     * @uses UpdateUserReq::setPassword()
     * @uses UpdateUserReq::setPin()
     * @uses UpdateUserReq::setMailid()
     * @uses UpdateUserReq::setDepartment()
     * @uses UpdateUserReq::setManager()
     * @uses UpdateUserReq::setUserLocale()
     * @uses UpdateUserReq::setAssociatedDevices()
     * @uses UpdateUserReq::setPrimaryExtension()
     * @uses UpdateUserReq::setAssociatedPc()
     * @uses UpdateUserReq::setAssociatedGroups()
     * @uses UpdateUserReq::setEnableCti()
     * @uses UpdateUserReq::setDigestCredentials()
     * @uses UpdateUserReq::setPhoneProfiles()
     * @uses UpdateUserReq::setDefaultProfile()
     * @uses UpdateUserReq::setPresenceGroupName()
     * @uses UpdateUserReq::setSubscribeCallingSearchSpaceName()
     * @uses UpdateUserReq::setEnableMobility()
     * @uses UpdateUserReq::setEnableMobileVoiceAccess()
     * @uses UpdateUserReq::setMaxDeskPickupWaitTime()
     * @uses UpdateUserReq::setRemoteDestinationLimit()
     * @uses UpdateUserReq::setPasswordCredentials()
     * @uses UpdateUserReq::setPinCredentials()
     * @uses UpdateUserReq::setPrimaryDevice()
     * @uses UpdateUserReq::setEnableEmcc()
     * @uses UpdateUserReq::setCtiControlledDeviceProfiles()
     * @uses UpdateUserReq::setPatternPrecedence()
     * @uses UpdateUserReq::setNumericUserId()
     * @uses UpdateUserReq::setMlppPassword()
     * @uses UpdateUserReq::setCustomUserFields()
     * @uses UpdateUserReq::setHomeCluster()
     * @uses UpdateUserReq::setImAndPresenceEnable()
     * @uses UpdateUserReq::setServiceProfile()
     * @uses UpdateUserReq::setLineAppearanceAssociationForPresences()
     * @uses UpdateUserReq::setDirectoryUri()
     * @uses UpdateUserReq::setTelephoneNumber()
     * @uses UpdateUserReq::setTitle()
     * @uses UpdateUserReq::setMobileNumber()
     * @uses UpdateUserReq::setHomeNumber()
     * @uses UpdateUserReq::setPagerNumber()
     * @uses UpdateUserReq::setRemoveExtensionsInfo()
     * @uses UpdateUserReq::setAddExtensionsInfo()
     * @uses UpdateUserReq::setExtensionsInfo()
     * @uses UpdateUserReq::setSelfService()
     * @uses UpdateUserReq::setUserProfile()
     * @uses UpdateUserReq::setCalendarPresence()
     * @uses UpdateUserReq::setLdapDirectoryName()
     * @uses UpdateUserReq::setUserIdentity()
     * @uses UpdateUserReq::setNameDialing()
     * @uses UpdateUserReq::setIpccExtension()
     * @uses UpdateUserReq::setConvertUserAccount()
     * @uses UpdateUserReq::setAccountType()
     * @uses UpdateUserReq::setAuthenticationType()
     * @param string $userid
     * @param string $uuid
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $newUserid
     * @param string $password
     * @param string $pin
     * @param string $mailid
     * @param string $department
     * @param string $manager
     * @param string $userLocale
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension
     * @param string $associatedPc
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @param string $enableCti
     * @param string $digestCredentials
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWaitTime
     * @param string $remoteDestinationLimit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice
     * @param string $enableEmcc
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $patternPrecedence
     * @param string $numericUserId
     * @param string $mlppPassword
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields
     * @param string $homeCluster
     * @param string $imAndPresenceEnable
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @param string $directoryUri
     * @param string $telephoneNumber
     * @param string $title
     * @param string $mobileNumber
     * @param string $homeNumber
     * @param string $pagerNumber
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveExtensionsInfo $removeExtensionsInfo
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddExtensionsInfo $addExtensionsInfo
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo
     * @param string $selfService
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @param string $calendarPresence
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName
     * @param string $userIdentity
     * @param string $nameDialing
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount
     * @param string $accountType
     * @param string $authenticationType
     */
    public function __construct($userid = null, $uuid = null, $firstName = null, $middleName = null, $lastName = null, $newUserid = null, $password = null, $pin = null, $mailid = null, $department = null, $manager = null, $userLocale = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension = null, $associatedPc = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null, $enableCti = 'true', $digestCredentials = null, \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, $enableMobility = 'false', $enableMobileVoiceAccess = 'false', $maxDeskPickupWaitTime = '10000', $remoteDestinationLimit = '4', \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null, \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice = null, $enableEmcc = null, \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $patternPrecedence = 'Default', $numericUserId = null, $mlppPassword = null, \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields = null, $homeCluster = 'true', $imAndPresenceEnable = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null, \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null, $directoryUri = null, $telephoneNumber = null, $title = null, $mobileNumber = null, $homeNumber = null, $pagerNumber = null, \Losc\CucmBundle\Model\Webservice\StructType\RemoveExtensionsInfo $removeExtensionsInfo = null, \Losc\CucmBundle\Model\Webservice\StructType\AddExtensionsInfo $addExtensionsInfo = null, \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo = null, $selfService = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null, $calendarPresence = 'false', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName = null, $userIdentity = null, $nameDialing = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount = null, $accountType = 'Local', $authenticationType = 'Local')
    {
        $this
            ->setUserid($userid)
            ->setUuid($uuid)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setNewUserid($newUserid)
            ->setPassword($password)
            ->setPin($pin)
            ->setMailid($mailid)
            ->setDepartment($department)
            ->setManager($manager)
            ->setUserLocale($userLocale)
            ->setAssociatedDevices($associatedDevices)
            ->setPrimaryExtension($primaryExtension)
            ->setAssociatedPc($associatedPc)
            ->setAssociatedGroups($associatedGroups)
            ->setEnableCti($enableCti)
            ->setDigestCredentials($digestCredentials)
            ->setPhoneProfiles($phoneProfiles)
            ->setDefaultProfile($defaultProfile)
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWaitTime($maxDeskPickupWaitTime)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setPasswordCredentials($passwordCredentials)
            ->setPinCredentials($pinCredentials)
            ->setPrimaryDevice($primaryDevice)
            ->setEnableEmcc($enableEmcc)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setPatternPrecedence($patternPrecedence)
            ->setNumericUserId($numericUserId)
            ->setMlppPassword($mlppPassword)
            ->setCustomUserFields($customUserFields)
            ->setHomeCluster($homeCluster)
            ->setImAndPresenceEnable($imAndPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setLineAppearanceAssociationForPresences($lineAppearanceAssociationForPresences)
            ->setDirectoryUri($directoryUri)
            ->setTelephoneNumber($telephoneNumber)
            ->setTitle($title)
            ->setMobileNumber($mobileNumber)
            ->setHomeNumber($homeNumber)
            ->setPagerNumber($pagerNumber)
            ->setRemoveExtensionsInfo($removeExtensionsInfo)
            ->setAddExtensionsInfo($addExtensionsInfo)
            ->setExtensionsInfo($extensionsInfo)
            ->setSelfService($selfService)
            ->setUserProfile($userProfile)
            ->setCalendarPresence($calendarPresence)
            ->setLdapDirectoryName($ldapDirectoryName)
            ->setUserIdentity($userIdentity)
            ->setNameDialing($nameDialing)
            ->setIpccExtension($ipccExtension)
            ->setConvertUserAccount($convertUserAccount)
            ->setAccountType($accountType)
            ->setAuthenticationType($authenticationType);
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return isset($this->userid) ? $this->userid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUserid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUseridForChoiceConstraintsFromSetUserid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property userid can\'t be set as the property %s is already set. Only one property must be set among these properties: userid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set userid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $userid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        // validation for constraint: choice(uuid, userid)
        if ('' !== ($useridChoiceErrorMessage = self::validateUseridForChoiceConstraintsFromSetUserid($userid))) {
            throw new \InvalidArgumentException($useridChoiceErrorMessage, __LINE__);
        }
        if (is_null($userid) || (is_array($userid) && empty($userid))) {
            unset($this->userid);
        } else {
            $this->userid = $userid;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'userid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, userid)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get newUserid value
     * @return string|null
     */
    public function getNewUserid()
    {
        return $this->newUserid;
    }
    /**
     * Set newUserid value
     * @param string $newUserid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setNewUserid($newUserid = null)
    {
        // validation for constraint: string
        if (!is_null($newUserid) && !is_string($newUserid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newUserid, true), gettype($newUserid)), __LINE__);
        }
        $this->newUserid = $newUserid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get mailid value
     * @return string|null
     */
    public function getMailid()
    {
        return $this->mailid;
    }
    /**
     * Set mailid value
     * @param string $mailid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setMailid($mailid = null)
    {
        // validation for constraint: string
        if (!is_null($mailid) && !is_string($mailid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailid, true), gettype($mailid)), __LINE__);
        }
        $this->mailid = $mailid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manager, true), gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($userLocale) ? implode(', ', $userLocale) : var_export($userLocale, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setAssociatedDevices(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get primaryExtension value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension|null
     */
    public function getPrimaryExtension()
    {
        return $this->primaryExtension;
    }
    /**
     * Set primaryExtension value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPrimaryExtension(\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension = null)
    {
        $this->primaryExtension = $primaryExtension;
        return $this;
    }
    /**
     * Get associatedPc value
     * @return string|null
     */
    public function getAssociatedPc()
    {
        return $this->associatedPc;
    }
    /**
     * Set associatedPc value
     * @param string $associatedPc
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setAssociatedPc($associatedPc = null)
    {
        // validation for constraint: string
        if (!is_null($associatedPc) && !is_string($associatedPc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedPc, true), gettype($associatedPc)), __LINE__);
        }
        $this->associatedPc = $associatedPc;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setAssociatedGroups(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get enableCti value
     * @return string|null
     */
    public function getEnableCti()
    {
        return $this->enableCti;
    }
    /**
     * Set enableCti value
     * @param string $enableCti
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setEnableCti($enableCti = 'true')
    {
        // validation for constraint: string
        if (!is_null($enableCti) && !is_string($enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableCti, true), gettype($enableCti)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableCti, true)), __LINE__);
        }
        $this->enableCti = $enableCti;
        return $this;
    }
    /**
     * Get digestCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return isset($this->digestCredentials) ? $this->digestCredentials : null;
    }
    /**
     * Set digestCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $digestCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestCredentials, true), gettype($digestCredentials)), __LINE__);
        }
        if (is_null($digestCredentials) || (is_array($digestCredentials) && empty($digestCredentials))) {
            unset($this->digestCredentials);
        } else {
            $this->digestCredentials = $digestCredentials;
        }
        return $this;
    }
    /**
     * Get phoneProfiles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles|null
     */
    public function getPhoneProfiles()
    {
        return $this->phoneProfiles;
    }
    /**
     * Set phoneProfiles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPhoneProfiles(\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles = null)
    {
        $this->phoneProfiles = $phoneProfiles;
        return $this;
    }
    /**
     * Get defaultProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultProfile()
    {
        return $this->defaultProfile;
    }
    /**
     * Set defaultProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setDefaultProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile = null)
    {
        $this->defaultProfile = $defaultProfile;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPresenceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setSubscribeCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setEnableMobility($enableMobility = 'false')
    {
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobility, true), gettype($enableMobility)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobility, true)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = 'false')
    {
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobileVoiceAccess, true), gettype($enableMobileVoiceAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWaitTime value
     * @return string|null
     */
    public function getMaxDeskPickupWaitTime()
    {
        return $this->maxDeskPickupWaitTime;
    }
    /**
     * Set maxDeskPickupWaitTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWaitTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setMaxDeskPickupWaitTime($maxDeskPickupWaitTime = '10000')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxDeskPickupWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxDeskPickupWaitTime) ? implode(', ', $maxDeskPickupWaitTime) : var_export($maxDeskPickupWaitTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWaitTime = $maxDeskPickupWaitTime;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = '4')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($remoteDestinationLimit) ? implode(', ', $remoteDestinationLimit) : var_export($remoteDestinationLimit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPasswordCredentials(\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get pinCredentials value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials|null
     */
    public function getPinCredentials()
    {
        return $this->pinCredentials;
    }
    /**
     * Set pinCredentials value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPinCredentials(\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials = null)
    {
        $this->pinCredentials = $pinCredentials;
        return $this;
    }
    /**
     * Get primaryDevice value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryDevice()
    {
        return $this->primaryDevice;
    }
    /**
     * Set primaryDevice value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPrimaryDevice(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice = null)
    {
        $this->primaryDevice = $primaryDevice;
        return $this;
    }
    /**
     * Get enableEmcc value
     * @return string|null
     */
    public function getEnableEmcc()
    {
        return $this->enableEmcc;
    }
    /**
     * Set enableEmcc value
     * @param string $enableEmcc
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setEnableEmcc($enableEmcc = null)
    {
        // validation for constraint: string
        if (!is_null($enableEmcc) && !is_string($enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableEmcc, true), gettype($enableEmcc)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableEmcc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableEmcc, true)), __LINE__);
        }
        $this->enableEmcc = $enableEmcc;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setCtiControlledDeviceProfiles(\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get numericUserId value
     * @return string|null
     */
    public function getNumericUserId()
    {
        return $this->numericUserId;
    }
    /**
     * Set numericUserId value
     * @param string $numericUserId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setNumericUserId($numericUserId = null)
    {
        // validation for constraint: string
        if (!is_null($numericUserId) && !is_string($numericUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numericUserId, true), gettype($numericUserId)), __LINE__);
        }
        $this->numericUserId = $numericUserId;
        return $this;
    }
    /**
     * Get mlppPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppPassword()
    {
        return isset($this->mlppPassword) ? $this->mlppPassword : null;
    }
    /**
     * Set mlppPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppPassword
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setMlppPassword($mlppPassword = null)
    {
        // validation for constraint: string
        if (!is_null($mlppPassword) && !is_string($mlppPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppPassword, true), gettype($mlppPassword)), __LINE__);
        }
        if (is_null($mlppPassword) || (is_array($mlppPassword) && empty($mlppPassword))) {
            unset($this->mlppPassword);
        } else {
            $this->mlppPassword = $mlppPassword;
        }
        return $this;
    }
    /**
     * Get customUserFields value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields|null
     */
    public function getCustomUserFields()
    {
        return $this->customUserFields;
    }
    /**
     * Set customUserFields value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setCustomUserFields(\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields = null)
    {
        $this->customUserFields = $customUserFields;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setHomeCluster($homeCluster = 'true')
    {
        // validation for constraint: string
        if (!is_null($homeCluster) && !is_string($homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCluster, true), gettype($homeCluster)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($homeCluster) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($homeCluster, true)), __LINE__);
        }
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndPresenceEnable value
     * @return string|null
     */
    public function getImAndPresenceEnable()
    {
        return $this->imAndPresenceEnable;
    }
    /**
     * Set imAndPresenceEnable value
     * @param string $imAndPresenceEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setImAndPresenceEnable($imAndPresenceEnable = null)
    {
        // validation for constraint: string
        if (!is_null($imAndPresenceEnable) && !is_string($imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imAndPresenceEnable, true), gettype($imAndPresenceEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($imAndPresenceEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($imAndPresenceEnable, true)), __LINE__);
        }
        $this->imAndPresenceEnable = $imAndPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServiceProfile()
    {
        return isset($this->serviceProfile) ? $this->serviceProfile : null;
    }
    /**
     * Set serviceProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setServiceProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null)
    {
        if (is_null($serviceProfile) || (is_array($serviceProfile) && empty($serviceProfile))) {
            unset($this->serviceProfile);
        } else {
            $this->serviceProfile = $serviceProfile;
        }
        return $this;
    }
    /**
     * Get lineAppearanceAssociationForPresences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences|null
     */
    public function getLineAppearanceAssociationForPresences()
    {
        return $this->lineAppearanceAssociationForPresences;
    }
    /**
     * Set lineAppearanceAssociationForPresences value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setLineAppearanceAssociationForPresences(\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null)
    {
        $this->lineAppearanceAssociationForPresences = $lineAppearanceAssociationForPresences;
        return $this;
    }
    /**
     * Get directoryUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return isset($this->directoryUri) ? $this->directoryUri : null;
    }
    /**
     * Set directoryUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryUri, true), gettype($directoryUri)), __LINE__);
        }
        if (is_null($directoryUri) || (is_array($directoryUri) && empty($directoryUri))) {
            unset($this->directoryUri);
        } else {
            $this->directoryUri = $directoryUri;
        }
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephoneNumber, true), gettype($telephoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($telephoneNumber) && mb_strlen($telephoneNumber) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get mobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->mobileNumber;
    }
    /**
     * Set mobileNumber value
     * @param string $mobileNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setMobileNumber($mobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNumber) && !is_string($mobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileNumber, true), gettype($mobileNumber)), __LINE__);
        }
        $this->mobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get homeNumber value
     * @return string|null
     */
    public function getHomeNumber()
    {
        return $this->homeNumber;
    }
    /**
     * Set homeNumber value
     * @param string $homeNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setHomeNumber($homeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homeNumber) && !is_string($homeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeNumber, true), gettype($homeNumber)), __LINE__);
        }
        $this->homeNumber = $homeNumber;
        return $this;
    }
    /**
     * Get pagerNumber value
     * @return string|null
     */
    public function getPagerNumber()
    {
        return $this->pagerNumber;
    }
    /**
     * Set pagerNumber value
     * @param string $pagerNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setPagerNumber($pagerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pagerNumber) && !is_string($pagerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagerNumber, true), gettype($pagerNumber)), __LINE__);
        }
        $this->pagerNumber = $pagerNumber;
        return $this;
    }
    /**
     * Get removeExtensionsInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveExtensionsInfo|null
     */
    public function getRemoveExtensionsInfo()
    {
        return isset($this->removeExtensionsInfo) ? $this->removeExtensionsInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveExtensionsInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveExtensionsInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveExtensionsInfoForChoiceConstraintsFromSetRemoveExtensionsInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addExtensionsInfo',
            'extensionsInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeExtensionsInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: removeExtensionsInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeExtensionsInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveExtensionsInfo $removeExtensionsInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setRemoveExtensionsInfo(\Losc\CucmBundle\Model\Webservice\StructType\RemoveExtensionsInfo $removeExtensionsInfo = null)
    {
        // validation for constraint: choice(removeExtensionsInfo, addExtensionsInfo, extensionsInfo)
        if ('' !== ($removeExtensionsInfoChoiceErrorMessage = self::validateRemoveExtensionsInfoForChoiceConstraintsFromSetRemoveExtensionsInfo($removeExtensionsInfo))) {
            throw new \InvalidArgumentException($removeExtensionsInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeExtensionsInfo) || (is_array($removeExtensionsInfo) && empty($removeExtensionsInfo))) {
            unset($this->removeExtensionsInfo);
        } else {
            $this->removeExtensionsInfo = $removeExtensionsInfo;
        }
        return $this;
    }
    /**
     * Get addExtensionsInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddExtensionsInfo|null
     */
    public function getAddExtensionsInfo()
    {
        return isset($this->addExtensionsInfo) ? $this->addExtensionsInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddExtensionsInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddExtensionsInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddExtensionsInfoForChoiceConstraintsFromSetAddExtensionsInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeExtensionsInfo',
            'extensionsInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addExtensionsInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: addExtensionsInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addExtensionsInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddExtensionsInfo $addExtensionsInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setAddExtensionsInfo(\Losc\CucmBundle\Model\Webservice\StructType\AddExtensionsInfo $addExtensionsInfo = null)
    {
        // validation for constraint: choice(removeExtensionsInfo, addExtensionsInfo, extensionsInfo)
        if ('' !== ($addExtensionsInfoChoiceErrorMessage = self::validateAddExtensionsInfoForChoiceConstraintsFromSetAddExtensionsInfo($addExtensionsInfo))) {
            throw new \InvalidArgumentException($addExtensionsInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($addExtensionsInfo) || (is_array($addExtensionsInfo) && empty($addExtensionsInfo))) {
            unset($this->addExtensionsInfo);
        } else {
            $this->addExtensionsInfo = $addExtensionsInfo;
        }
        return $this;
    }
    /**
     * Get extensionsInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo|null
     */
    public function getExtensionsInfo()
    {
        return isset($this->extensionsInfo) ? $this->extensionsInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExtensionsInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensionsInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExtensionsInfoForChoiceConstraintsFromSetExtensionsInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeExtensionsInfo',
            'addExtensionsInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property extensionsInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: extensionsInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set extensionsInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setExtensionsInfo(\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo = null)
    {
        // validation for constraint: choice(removeExtensionsInfo, addExtensionsInfo, extensionsInfo)
        if ('' !== ($extensionsInfoChoiceErrorMessage = self::validateExtensionsInfoForChoiceConstraintsFromSetExtensionsInfo($extensionsInfo))) {
            throw new \InvalidArgumentException($extensionsInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($extensionsInfo) || (is_array($extensionsInfo) && empty($extensionsInfo))) {
            unset($this->extensionsInfo);
        } else {
            $this->extensionsInfo = $extensionsInfo;
        }
        return $this;
    }
    /**
     * Get selfService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelfService()
    {
        return isset($this->selfService) ? $this->selfService : null;
    }
    /**
     * Set selfService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selfService
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setSelfService($selfService = null)
    {
        // validation for constraint: string
        if (!is_null($selfService) && !is_string($selfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selfService, true), gettype($selfService)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($selfService) && mb_strlen($selfService) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($selfService)), __LINE__);
        }
        if (is_null($selfService) || (is_array($selfService) && empty($selfService))) {
            unset($this->selfService);
        } else {
            $this->selfService = $selfService;
        }
        return $this;
    }
    /**
     * Get userProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUserProfile()
    {
        return isset($this->userProfile) ? $this->userProfile : null;
    }
    /**
     * Set userProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setUserProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null)
    {
        if (is_null($userProfile) || (is_array($userProfile) && empty($userProfile))) {
            unset($this->userProfile);
        } else {
            $this->userProfile = $userProfile;
        }
        return $this;
    }
    /**
     * Get calendarPresence value
     * @return string|null
     */
    public function getCalendarPresence()
    {
        return $this->calendarPresence;
    }
    /**
     * Set calendarPresence value
     * @param string $calendarPresence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setCalendarPresence($calendarPresence = 'false')
    {
        // validation for constraint: string
        if (!is_null($calendarPresence) && !is_string($calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendarPresence, true), gettype($calendarPresence)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($calendarPresence) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($calendarPresence, true)), __LINE__);
        }
        $this->calendarPresence = $calendarPresence;
        return $this;
    }
    /**
     * Get ldapDirectoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLdapDirectoryName()
    {
        return isset($this->ldapDirectoryName) ? $this->ldapDirectoryName : null;
    }
    /**
     * Set ldapDirectoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setLdapDirectoryName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName = null)
    {
        if (is_null($ldapDirectoryName) || (is_array($ldapDirectoryName) && empty($ldapDirectoryName))) {
            unset($this->ldapDirectoryName);
        } else {
            $this->ldapDirectoryName = $ldapDirectoryName;
        }
        return $this;
    }
    /**
     * Get userIdentity value
     * @return string|null
     */
    public function getUserIdentity()
    {
        return $this->userIdentity;
    }
    /**
     * Set userIdentity value
     * @param string $userIdentity
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setUserIdentity($userIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($userIdentity) && !is_string($userIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdentity, true), gettype($userIdentity)), __LINE__);
        }
        $this->userIdentity = $userIdentity;
        return $this;
    }
    /**
     * Get nameDialing value
     * @return string|null
     */
    public function getNameDialing()
    {
        return $this->nameDialing;
    }
    /**
     * Set nameDialing value
     * @param string $nameDialing
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setNameDialing($nameDialing = null)
    {
        // validation for constraint: string
        if (!is_null($nameDialing) && !is_string($nameDialing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameDialing, true), gettype($nameDialing)), __LINE__);
        }
        $this->nameDialing = $nameDialing;
        return $this;
    }
    /**
     * Get ipccExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIpccExtension()
    {
        return isset($this->ipccExtension) ? $this->ipccExtension : null;
    }
    /**
     * Set ipccExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setIpccExtension(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension = null)
    {
        if (is_null($ipccExtension) || (is_array($ipccExtension) && empty($ipccExtension))) {
            unset($this->ipccExtension);
        } else {
            $this->ipccExtension = $ipccExtension;
        }
        return $this;
    }
    /**
     * Get convertUserAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getConvertUserAccount()
    {
        return isset($this->convertUserAccount) ? $this->convertUserAccount : null;
    }
    /**
     * Set convertUserAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setConvertUserAccount(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount = null)
    {
        if (is_null($convertUserAccount) || (is_array($convertUserAccount) && empty($convertUserAccount))) {
            unset($this->convertUserAccount);
        } else {
            $this->convertUserAccount = $convertUserAccount;
        }
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setAccountType($accountType = 'Local')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType', is_array($accountType) ? implode(', ', $accountType) : var_export($accountType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::getValidValues())), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get authenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->authenticationType;
    }
    /**
     * Set authenticationType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq
     */
    public function setAuthenticationType($authenticationType = 'Local')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType', is_array($authenticationType) ? implode(', ', $authenticationType) : var_export($authenticationType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::getValidValues())), __LINE__);
        }
        $this->authenticationType = $authenticationType;
        return $this;
    }
}
