<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUcServiceReq StructType
 * @subpackage Structs
 */
class UpdateUcServiceReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The hostnameorip
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostnameorip;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence) and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $port;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence),CTI and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $protocol;
    /**
     * The ucServiceXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $ucServiceXml;
    /**
     * Constructor method for UpdateUcServiceReq
     * @uses UpdateUcServiceReq::setNewName()
     * @uses UpdateUcServiceReq::setDescription()
     * @uses UpdateUcServiceReq::setHostnameorip()
     * @uses UpdateUcServiceReq::setPort()
     * @uses UpdateUcServiceReq::setProtocol()
     * @uses UpdateUcServiceReq::setUcServiceXml()
     * @param string $newName
     * @param string $description
     * @param string $hostnameorip
     * @param string $port
     * @param string $protocol
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml
     */
    public function __construct($newName = null, $description = null, $hostnameorip = null, $port = null, $protocol = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setHostnameorip($hostnameorip)
            ->setPort($port)
            ->setProtocol($protocol)
            ->setUcServiceXml($ucServiceXml);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get hostnameorip value
     * @return string|null
     */
    public function getHostnameorip()
    {
        return $this->hostnameorip;
    }
    /**
     * Set hostnameorip value
     * @param string $hostnameorip
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq
     */
    public function setHostnameorip($hostnameorip = null)
    {
        // validation for constraint: string
        if (!is_null($hostnameorip) && !is_string($hostnameorip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostnameorip, true), gettype($hostnameorip)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($hostnameorip) && mb_strlen($hostnameorip) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($hostnameorip)), __LINE__);
        }
        $this->hostnameorip = $hostnameorip;
        return $this;
    }
    /**
     * Get port value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : null;
    }
    /**
     * Set port value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($port) || (is_array($port) && empty($port))) {
            unset($this->port);
        } else {
            $this->port = $port;
        }
        return $this;
    }
    /**
     * Get protocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtocol()
    {
        return isset($this->protocol) ? $this->protocol : null;
    }
    /**
     * Set protocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::getValidValues())), __LINE__);
        }
        if (is_null($protocol) || (is_array($protocol) && empty($protocol))) {
            unset($this->protocol);
        } else {
            $this->protocol = $protocol;
        }
        return $this;
    }
    /**
     * Get ucServiceXml value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getUcServiceXml()
    {
        return $this->ucServiceXml;
    }
    /**
     * Set ucServiceXml value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq
     */
    public function setUcServiceXml(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml = null)
    {
        $this->ucServiceXml = $ucServiceXml;
        return $this;
    }
}
