<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSafForwarderReq StructType
 * @subpackage Structs
 */
class UpdateSafForwarderReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The clientLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 5050
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta information extracted from the WSDL
     * - default: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta information extracted from the WSDL
     * - default: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The removeAssociatedCucms
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedCucms | addAssociatedCucms | associatedCucms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms
     */
    public $removeAssociatedCucms;
    /**
     * The addAssociatedCucms
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedCucms | addAssociatedCucms | associatedCucms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms
     */
    public $addAssociatedCucms;
    /**
     * The associatedCucms
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedCucms | addAssociatedCucms | associatedCucms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms
     */
    public $associatedCucms;
    /**
     * Constructor method for UpdateSafForwarderReq
     * @uses UpdateSafForwarderReq::setNewName()
     * @uses UpdateSafForwarderReq::setDescription()
     * @uses UpdateSafForwarderReq::setClientLabel()
     * @uses UpdateSafForwarderReq::setSafSecurityProfile()
     * @uses UpdateSafForwarderReq::setIpAddress()
     * @uses UpdateSafForwarderReq::setPort()
     * @uses UpdateSafForwarderReq::setEnableTcpKeepAlive()
     * @uses UpdateSafForwarderReq::setSafReconnectInterval()
     * @uses UpdateSafForwarderReq::setSafNotificationsWindowSize()
     * @uses UpdateSafForwarderReq::setRemoveAssociatedCucms()
     * @uses UpdateSafForwarderReq::setAddAssociatedCucms()
     * @uses UpdateSafForwarderReq::setAssociatedCucms()
     * @param string $newName
     * @param string $description
     * @param string $clientLabel
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms
     */
    public function __construct($newName = null, $description = null, $clientLabel = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile = null, $ipAddress = null, $port = '5050', $enableTcpKeepAlive = 'true', $safReconnectInterval = '20', $safNotificationsWindowSize = '7', \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms = null, \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setRemoveAssociatedCucms($removeAssociatedCucms)
            ->setAddAssociatedCucms($addAssociatedCucms)
            ->setAssociatedCucms($associatedCucms);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($newName) && mb_strlen($newName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string|null
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setClientLabel($clientLabel = null)
    {
        // validation for constraint: string
        if (!is_null($clientLabel) && !is_string($clientLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLabel, true), gettype($clientLabel)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($clientLabel) && mb_strlen($clientLabel) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($clientLabel)), __LINE__);
        }
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setSafSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ipAddress) && mb_strlen($ipAddress) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setPort($port = '5050')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = 'true')
    {
        // validation for constraint: string
        if (!is_null($enableTcpKeepAlive) && !is_string($enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableTcpKeepAlive, true), gettype($enableTcpKeepAlive)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableTcpKeepAlive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableTcpKeepAlive, true)), __LINE__);
        }
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safReconnectInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setSafReconnectInterval($safReconnectInterval = '20')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($safReconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($safReconnectInterval) ? implode(', ', $safReconnectInterval) : var_export($safReconnectInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safNotificationsWindowSize
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = '7')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($safNotificationsWindowSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($safNotificationsWindowSize) ? implode(', ', $safNotificationsWindowSize) : var_export($safNotificationsWindowSize, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get removeAssociatedCucms value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms|null
     */
    public function getRemoveAssociatedCucms()
    {
        return isset($this->removeAssociatedCucms) ? $this->removeAssociatedCucms : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveAssociatedCucms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveAssociatedCucms method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveAssociatedCucmsForChoiceConstraintsFromSetRemoveAssociatedCucms($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addAssociatedCucms',
            'associatedCucms',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeAssociatedCucms can\'t be set as the property %s is already set. Only one property must be set among these properties: removeAssociatedCucms, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeAssociatedCucms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setRemoveAssociatedCucms(\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms = null)
    {
        // validation for constraint: choice(removeAssociatedCucms, addAssociatedCucms, associatedCucms)
        if ('' !== ($removeAssociatedCucmsChoiceErrorMessage = self::validateRemoveAssociatedCucmsForChoiceConstraintsFromSetRemoveAssociatedCucms($removeAssociatedCucms))) {
            throw new \InvalidArgumentException($removeAssociatedCucmsChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeAssociatedCucms) || (is_array($removeAssociatedCucms) && empty($removeAssociatedCucms))) {
            unset($this->removeAssociatedCucms);
        } else {
            $this->removeAssociatedCucms = $removeAssociatedCucms;
        }
        return $this;
    }
    /**
     * Get addAssociatedCucms value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms|null
     */
    public function getAddAssociatedCucms()
    {
        return isset($this->addAssociatedCucms) ? $this->addAssociatedCucms : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddAssociatedCucms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddAssociatedCucms method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddAssociatedCucmsForChoiceConstraintsFromSetAddAssociatedCucms($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeAssociatedCucms',
            'associatedCucms',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addAssociatedCucms can\'t be set as the property %s is already set. Only one property must be set among these properties: addAssociatedCucms, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addAssociatedCucms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setAddAssociatedCucms(\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms = null)
    {
        // validation for constraint: choice(removeAssociatedCucms, addAssociatedCucms, associatedCucms)
        if ('' !== ($addAssociatedCucmsChoiceErrorMessage = self::validateAddAssociatedCucmsForChoiceConstraintsFromSetAddAssociatedCucms($addAssociatedCucms))) {
            throw new \InvalidArgumentException($addAssociatedCucmsChoiceErrorMessage, __LINE__);
        }
        if (is_null($addAssociatedCucms) || (is_array($addAssociatedCucms) && empty($addAssociatedCucms))) {
            unset($this->addAssociatedCucms);
        } else {
            $this->addAssociatedCucms = $addAssociatedCucms;
        }
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return isset($this->associatedCucms) ? $this->associatedCucms : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAssociatedCucms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedCucms method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAssociatedCucmsForChoiceConstraintsFromSetAssociatedCucms($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeAssociatedCucms',
            'addAssociatedCucms',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property associatedCucms can\'t be set as the property %s is already set. Only one property must be set among these properties: associatedCucms, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set associatedCucms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setAssociatedCucms(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms = null)
    {
        // validation for constraint: choice(removeAssociatedCucms, addAssociatedCucms, associatedCucms)
        if ('' !== ($associatedCucmsChoiceErrorMessage = self::validateAssociatedCucmsForChoiceConstraintsFromSetAssociatedCucms($associatedCucms))) {
            throw new \InvalidArgumentException($associatedCucmsChoiceErrorMessage, __LINE__);
        }
        if (is_null($associatedCucms) || (is_array($associatedCucms) && empty($associatedCucms))) {
            unset($this->associatedCucms);
        } else {
            $this->associatedCucms = $associatedCucms;
        }
        return $this;
    }
}
