<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneNtpReq StructType
 * @subpackage Structs
 */
class UpdatePhoneNtpReq extends APIRequest
{
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - choice: uuid | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newIpAddress;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mode
     * Meta information extracted from the WSDL
     * - default: Directed Broadcast
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mode;
    /**
     * Constructor method for UpdatePhoneNtpReq
     * @uses UpdatePhoneNtpReq::setIpAddress()
     * @uses UpdatePhoneNtpReq::setUuid()
     * @uses UpdatePhoneNtpReq::setNewIpAddress()
     * @uses UpdatePhoneNtpReq::setDescription()
     * @uses UpdatePhoneNtpReq::setMode()
     * @param string $ipAddress
     * @param string $uuid
     * @param string $newIpAddress
     * @param string $description
     * @param string $mode
     */
    public function __construct($ipAddress = null, $uuid = null, $newIpAddress = null, $description = null, $mode = 'Directed Broadcast')
    {
        $this
            ->setIpAddress($ipAddress)
            ->setUuid($uuid)
            ->setNewIpAddress($newIpAddress)
            ->setDescription($description)
            ->setMode($mode);
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return isset($this->ipAddress) ? $this->ipAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIpAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIpAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIpAddressForChoiceConstraintsFromSetIpAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ipAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: ipAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ipAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ipAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        // validation for constraint: choice(uuid, ipAddress)
        if ('' !== ($ipAddressChoiceErrorMessage = self::validateIpAddressForChoiceConstraintsFromSetIpAddress($ipAddress))) {
            throw new \InvalidArgumentException($ipAddressChoiceErrorMessage, __LINE__);
        }
        if (is_null($ipAddress) || (is_array($ipAddress) && empty($ipAddress))) {
            unset($this->ipAddress);
        } else {
            $this->ipAddress = $ipAddress;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ipAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, ipAddress)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newIpAddress value
     * @return string|null
     */
    public function getNewIpAddress()
    {
        return $this->newIpAddress;
    }
    /**
     * Set newIpAddress value
     * @param string $newIpAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setNewIpAddress($newIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newIpAddress) && !is_string($newIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newIpAddress, true), gettype($newIpAddress)), __LINE__);
        }
        $this->newIpAddress = $newIpAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XZzntpmode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XZzntpmode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setMode($mode = 'Directed Broadcast')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XZzntpmode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XZzntpmode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XZzntpmode::getValidValues())), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
}
