<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateNetworkAccessProfileReq StructType
 * @subpackage Structs
 */
class UpdateNetworkAccessProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The vpnRequired
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $vpnRequired;
    /**
     * The proxySettings
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxySettings;
    /**
     * The proxyHostname
     * Meta information extracted from the WSDL
     * - documentation: This tag corresponds to Proxy Auto-Config (PAC) Location when proxy setting is set to Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyHostname;
    /**
     * The proxyPort
     * Meta information extracted from the WSDL
     * - default: 8080
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyPort;
    /**
     * The proxyRequiresAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $proxyRequiresAuthentication;
    /**
     * The provideSharedCredentials
     * Meta information extracted from the WSDL
     * - documentation: This tag is used for validation and does not correspond to any field in database.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideSharedCredentials;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * Constructor method for UpdateNetworkAccessProfileReq
     * @uses UpdateNetworkAccessProfileReq::setNewName()
     * @uses UpdateNetworkAccessProfileReq::setDescription()
     * @uses UpdateNetworkAccessProfileReq::setVpnRequired()
     * @uses UpdateNetworkAccessProfileReq::setProxySettings()
     * @uses UpdateNetworkAccessProfileReq::setProxyHostname()
     * @uses UpdateNetworkAccessProfileReq::setProxyPort()
     * @uses UpdateNetworkAccessProfileReq::setProxyRequiresAuthentication()
     * @uses UpdateNetworkAccessProfileReq::setProvideSharedCredentials()
     * @uses UpdateNetworkAccessProfileReq::setUsername()
     * @uses UpdateNetworkAccessProfileReq::setPassword()
     * @param string $newName
     * @param string $description
     * @param string $vpnRequired
     * @param string $proxySettings
     * @param string $proxyHostname
     * @param string $proxyPort
     * @param string $proxyRequiresAuthentication
     * @param string $provideSharedCredentials
     * @param string $username
     * @param string $password
     */
    public function __construct($newName = null, $description = null, $vpnRequired = 'Default', $proxySettings = 'None', $proxyHostname = null, $proxyPort = '8080', $proxyRequiresAuthentication = 'false', $provideSharedCredentials = 'false', $username = null, $password = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setVpnRequired($vpnRequired)
            ->setProxySettings($proxySettings)
            ->setProxyHostname($proxyHostname)
            ->setProxyPort($proxyPort)
            ->setProxyRequiresAuthentication($proxyRequiresAuthentication)
            ->setProvideSharedCredentials($provideSharedCredentials)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($newName) && mb_strlen($newName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnRequired value
     * @return string|null
     */
    public function getVpnRequired()
    {
        return $this->vpnRequired;
    }
    /**
     * Set vpnRequired value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vpnRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setVpnRequired($vpnRequired = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($vpnRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($vpnRequired) ? implode(', ', $vpnRequired) : var_export($vpnRequired, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->vpnRequired = $vpnRequired;
        return $this;
    }
    /**
     * Get proxySettings value
     * @return string|null
     */
    public function getProxySettings()
    {
        return $this->proxySettings;
    }
    /**
     * Set proxySettings value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxySettings
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxySettings($proxySettings = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::valueIsValid($proxySettings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy', is_array($proxySettings) ? implode(', ', $proxySettings) : var_export($proxySettings, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::getValidValues())), __LINE__);
        }
        $this->proxySettings = $proxySettings;
        return $this;
    }
    /**
     * Get proxyHostname value
     * @return string|null
     */
    public function getProxyHostname()
    {
        return $this->proxyHostname;
    }
    /**
     * Set proxyHostname value
     * @param string $proxyHostname
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyHostname($proxyHostname = null)
    {
        // validation for constraint: string
        if (!is_null($proxyHostname) && !is_string($proxyHostname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proxyHostname, true), gettype($proxyHostname)), __LINE__);
        }
        $this->proxyHostname = $proxyHostname;
        return $this;
    }
    /**
     * Get proxyPort value
     * @return string|null
     */
    public function getProxyPort()
    {
        return $this->proxyPort;
    }
    /**
     * Set proxyPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxyPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyPort($proxyPort = '8080')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($proxyPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($proxyPort) ? implode(', ', $proxyPort) : var_export($proxyPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->proxyPort = $proxyPort;
        return $this;
    }
    /**
     * Get proxyRequiresAuthentication value
     * @return string|null
     */
    public function getProxyRequiresAuthentication()
    {
        return $this->proxyRequiresAuthentication;
    }
    /**
     * Set proxyRequiresAuthentication value
     * @param string $proxyRequiresAuthentication
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyRequiresAuthentication($proxyRequiresAuthentication = 'false')
    {
        // validation for constraint: string
        if (!is_null($proxyRequiresAuthentication) && !is_string($proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proxyRequiresAuthentication, true), gettype($proxyRequiresAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($proxyRequiresAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($proxyRequiresAuthentication, true)), __LINE__);
        }
        $this->proxyRequiresAuthentication = $proxyRequiresAuthentication;
        return $this;
    }
    /**
     * Get provideSharedCredentials value
     * @return string|null
     */
    public function getProvideSharedCredentials()
    {
        return $this->provideSharedCredentials;
    }
    /**
     * Set provideSharedCredentials value
     * @param string $provideSharedCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProvideSharedCredentials($provideSharedCredentials = 'false')
    {
        // validation for constraint: string
        if (!is_null($provideSharedCredentials) && !is_string($provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provideSharedCredentials, true), gettype($provideSharedCredentials)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($provideSharedCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($provideSharedCredentials, true)), __LINE__);
        }
        $this->provideSharedCredentials = $provideSharedCredentials;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
}
