<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapAuthenticationReq StructType
 * @subpackage Structs
 */
class UpdateLdapAuthenticationReq extends AbstractStructBase
{
    /**
     * The authenticateEndUsers
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authenticateEndUsers;
    /**
     * The distinguishedName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $distinguishedName;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userSearchBase;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public $servers;
    /**
     * Constructor method for UpdateLdapAuthenticationReq
     * @uses UpdateLdapAuthenticationReq::setAuthenticateEndUsers()
     * @uses UpdateLdapAuthenticationReq::setDistinguishedName()
     * @uses UpdateLdapAuthenticationReq::setLdapPassword()
     * @uses UpdateLdapAuthenticationReq::setUserSearchBase()
     * @uses UpdateLdapAuthenticationReq::setServers()
     * @param string $authenticateEndUsers
     * @param string $distinguishedName
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     */
    public function __construct($authenticateEndUsers = null, $distinguishedName = null, $ldapPassword = null, $userSearchBase = null, \Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null)
    {
        $this
            ->setAuthenticateEndUsers($authenticateEndUsers)
            ->setDistinguishedName($distinguishedName)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setServers($servers);
    }
    /**
     * Get authenticateEndUsers value
     * @return string|null
     */
    public function getAuthenticateEndUsers()
    {
        return $this->authenticateEndUsers;
    }
    /**
     * Set authenticateEndUsers value
     * @param string $authenticateEndUsers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq
     */
    public function setAuthenticateEndUsers($authenticateEndUsers = null)
    {
        // validation for constraint: string
        if (!is_null($authenticateEndUsers) && !is_string($authenticateEndUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticateEndUsers, true), gettype($authenticateEndUsers)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($authenticateEndUsers) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $authenticateEndUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($authenticateEndUsers, true)), __LINE__);
        }
        $this->authenticateEndUsers = $authenticateEndUsers;
        return $this;
    }
    /**
     * Get distinguishedName value
     * @return string|null
     */
    public function getDistinguishedName()
    {
        return $this->distinguishedName;
    }
    /**
     * Set distinguishedName value
     * @param string $distinguishedName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq
     */
    public function setDistinguishedName($distinguishedName = null)
    {
        // validation for constraint: string
        if (!is_null($distinguishedName) && !is_string($distinguishedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distinguishedName, true), gettype($distinguishedName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($distinguishedName) && mb_strlen($distinguishedName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($distinguishedName)), __LINE__);
        }
        $this->distinguishedName = $distinguishedName;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapPassword, true), gettype($ldapPassword)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapPassword) && mb_strlen($ldapPassword) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userSearchBase, true), gettype($userSearchBase)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($userSearchBase) && mb_strlen($userSearchBase) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get servers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq
     */
    public function setServers(\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
}
