<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeServerReq StructType
 * @subpackage Structs
 */
class UpdateImeServerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Value shpuld be between 1024 and 65535
     * - default: 5620
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - default: Authenticated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $applicationUser;
    /**
     * The reconnectInterval
     * Meta information extracted from the WSDL
     * - documentation: Value should be between 60 and 600
     * - default: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reconnectInterval;
    /**
     * Constructor method for UpdateImeServerReq
     * @uses UpdateImeServerReq::setNewName()
     * @uses UpdateImeServerReq::setDescription()
     * @uses UpdateImeServerReq::setIpAddress()
     * @uses UpdateImeServerReq::setPort()
     * @uses UpdateImeServerReq::setDeviceSecurityMode()
     * @uses UpdateImeServerReq::setApplicationUser()
     * @uses UpdateImeServerReq::setReconnectInterval()
     * @param string $newName
     * @param string $description
     * @param string $ipAddress
     * @param string $port
     * @param string $deviceSecurityMode
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @param string $reconnectInterval
     */
    public function __construct($newName = null, $description = null, $ipAddress = null, $port = '5620', $deviceSecurityMode = 'Authenticated', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null, $reconnectInterval = '120')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setApplicationUser($applicationUser)
            ->setReconnectInterval($reconnectInterval);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setPort($port = '5620')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XServerSecurityMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XServerSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setDeviceSecurityMode($deviceSecurityMode = 'Authenticated')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XServerSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XServerSecurityMode', is_array($deviceSecurityMode) ? implode(', ', $deviceSecurityMode) : var_export($deviceSecurityMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XServerSecurityMode::getValidValues())), __LINE__);
        }
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setApplicationUser(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reconnectInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setReconnectInterval($reconnectInterval = '120')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($reconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($reconnectInterval) ? implode(', ', $reconnectInterval) : var_export($reconnectInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
}
