<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeLearnedRoutesReq StructType
 * @subpackage Structs
 */
class UpdateImeLearnedRoutesReq extends APIRequest
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | e164Did
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The e164Did
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | e164Did
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 32
     * @var string
     */
    public $e164Did;
    /**
     * The adminEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $adminEnabled;
    /**
     * Constructor method for UpdateImeLearnedRoutesReq
     * @uses UpdateImeLearnedRoutesReq::setUuid()
     * @uses UpdateImeLearnedRoutesReq::setE164Did()
     * @uses UpdateImeLearnedRoutesReq::setAdminEnabled()
     * @param string $uuid
     * @param string $e164Did
     * @param string $adminEnabled
     */
    public function __construct($uuid = null, $e164Did = null, $adminEnabled = null)
    {
        $this
            ->setUuid($uuid)
            ->setE164Did($e164Did)
            ->setAdminEnabled($adminEnabled);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'e164Did',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeLearnedRoutesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, e164Did)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get e164Did value
     * @return string|null
     */
    public function getE164Did()
    {
        return isset($this->e164Did) ? $this->e164Did : null;
    }
    /**
     * This method is responsible for validating the value passed to the setE164Did method
     * This method is willingly generated in order to preserve the one-line inline validation within the setE164Did method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateE164DidForChoiceConstraintsFromSetE164Did($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property e164Did can\'t be set as the property %s is already set. Only one property must be set among these properties: e164Did, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set e164Did value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $e164Did
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeLearnedRoutesReq
     */
    public function setE164Did($e164Did = null)
    {
        // validation for constraint: string
        if (!is_null($e164Did) && !is_string($e164Did)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Did, true), gettype($e164Did)), __LINE__);
        }
        // validation for constraint: choice(uuid, e164Did)
        if ('' !== ($e164DidChoiceErrorMessage = self::validateE164DidForChoiceConstraintsFromSetE164Did($e164Did))) {
            throw new \InvalidArgumentException($e164DidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($e164Did) && mb_strlen($e164Did) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($e164Did)), __LINE__);
        }
        if (is_null($e164Did) || (is_array($e164Did) && empty($e164Did))) {
            unset($this->e164Did);
        } else {
            $this->e164Did = $e164Did;
        }
        return $this;
    }
    /**
     * Get adminEnabled value
     * @return string|null
     */
    public function getAdminEnabled()
    {
        return $this->adminEnabled;
    }
    /**
     * Set adminEnabled value
     * @param string $adminEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeLearnedRoutesReq
     */
    public function setAdminEnabled($adminEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($adminEnabled) && !is_string($adminEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adminEnabled, true), gettype($adminEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($adminEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $adminEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($adminEnabled, true)), __LINE__);
        }
        $this->adminEnabled = $adminEnabled;
        return $this;
    }
}
