<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeEnrolledPatternReq StructType
 * @subpackage Structs
 */
class UpdateImeEnrolledPatternReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * Constructor method for UpdateImeEnrolledPatternReq
     * @uses UpdateImeEnrolledPatternReq::setPattern()
     * @uses UpdateImeEnrolledPatternReq::setUuid()
     * @uses UpdateImeEnrolledPatternReq::setNewPattern()
     * @uses UpdateImeEnrolledPatternReq::setDescription()
     * @uses UpdateImeEnrolledPatternReq::setImeEnrolledPatternGroupName()
     * @param string $pattern
     * @param string $uuid
     * @param string $newPattern
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     */
    public function __construct($pattern = null, $uuid = null, $newPattern = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternForChoiceConstraintsFromSetPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pattern can\'t be set as the property %s is already set. Only one property must be set among these properties: pattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($patternChoiceErrorMessage = self::validatePatternForChoiceConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pattern) && mb_strlen($pattern) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pattern)), __LINE__);
        }
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pattern',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPattern, true), gettype($newPattern)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($newPattern) && mb_strlen($newPattern) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return isset($this->imeEnrolledPatternGroupName) ? $this->imeEnrolledPatternGroupName : null;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setImeEnrolledPatternGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        if (is_null($imeEnrolledPatternGroupName) || (is_array($imeEnrolledPatternGroupName) && empty($imeEnrolledPatternGroupName))) {
            unset($this->imeEnrolledPatternGroupName);
        } else {
            $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        }
        return $this;
    }
}
