<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateExternalCallControlProfileReq StructType
 * @subpackage Structs
 */
class UpdateExternalCallControlProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The primaryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryUri;
    /**
     * The secondaryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryUri;
    /**
     * The enableLoadBalancing
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableLoadBalancing;
    /**
     * The routingRequestTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $routingRequestTimer;
    /**
     * The diversionReroutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $diversionReroutingCssName;
    /**
     * The callTreatmentOnFailure
     * Meta information extracted from the WSDL
     * - default: Allow Calls
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callTreatmentOnFailure;
    /**
     * Constructor method for UpdateExternalCallControlProfileReq
     * @uses UpdateExternalCallControlProfileReq::setNewName()
     * @uses UpdateExternalCallControlProfileReq::setPrimaryUri()
     * @uses UpdateExternalCallControlProfileReq::setSecondaryUri()
     * @uses UpdateExternalCallControlProfileReq::setEnableLoadBalancing()
     * @uses UpdateExternalCallControlProfileReq::setRoutingRequestTimer()
     * @uses UpdateExternalCallControlProfileReq::setDiversionReroutingCssName()
     * @uses UpdateExternalCallControlProfileReq::setCallTreatmentOnFailure()
     * @param string $newName
     * @param string $primaryUri
     * @param string $secondaryUri
     * @param string $enableLoadBalancing
     * @param string $routingRequestTimer
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName
     * @param string $callTreatmentOnFailure
     */
    public function __construct($newName = null, $primaryUri = null, $secondaryUri = null, $enableLoadBalancing = 'false', $routingRequestTimer = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName = null, $callTreatmentOnFailure = 'Allow Calls')
    {
        $this
            ->setNewName($newName)
            ->setPrimaryUri($primaryUri)
            ->setSecondaryUri($secondaryUri)
            ->setEnableLoadBalancing($enableLoadBalancing)
            ->setRoutingRequestTimer($routingRequestTimer)
            ->setDiversionReroutingCssName($diversionReroutingCssName)
            ->setCallTreatmentOnFailure($callTreatmentOnFailure);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get primaryUri value
     * @return string|null
     */
    public function getPrimaryUri()
    {
        return $this->primaryUri;
    }
    /**
     * Set primaryUri value
     * @param string $primaryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setPrimaryUri($primaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($primaryUri) && !is_string($primaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryUri, true), gettype($primaryUri)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($primaryUri) && mb_strlen($primaryUri) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($primaryUri)), __LINE__);
        }
        $this->primaryUri = $primaryUri;
        return $this;
    }
    /**
     * Get secondaryUri value
     * @return string|null
     */
    public function getSecondaryUri()
    {
        return $this->secondaryUri;
    }
    /**
     * Set secondaryUri value
     * @param string $secondaryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setSecondaryUri($secondaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryUri) && !is_string($secondaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryUri, true), gettype($secondaryUri)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($secondaryUri) && mb_strlen($secondaryUri) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($secondaryUri)), __LINE__);
        }
        $this->secondaryUri = $secondaryUri;
        return $this;
    }
    /**
     * Get enableLoadBalancing value
     * @return string|null
     */
    public function getEnableLoadBalancing()
    {
        return $this->enableLoadBalancing;
    }
    /**
     * Set enableLoadBalancing value
     * @param string $enableLoadBalancing
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setEnableLoadBalancing($enableLoadBalancing = 'false')
    {
        // validation for constraint: string
        if (!is_null($enableLoadBalancing) && !is_string($enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableLoadBalancing, true), gettype($enableLoadBalancing)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableLoadBalancing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableLoadBalancing, true)), __LINE__);
        }
        $this->enableLoadBalancing = $enableLoadBalancing;
        return $this;
    }
    /**
     * Get routingRequestTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingRequestTimer()
    {
        return isset($this->routingRequestTimer) ? $this->routingRequestTimer : null;
    }
    /**
     * Set routingRequestTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routingRequestTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setRoutingRequestTimer($routingRequestTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($routingRequestTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($routingRequestTimer) ? implode(', ', $routingRequestTimer) : var_export($routingRequestTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($routingRequestTimer) || (is_array($routingRequestTimer) && empty($routingRequestTimer))) {
            unset($this->routingRequestTimer);
        } else {
            $this->routingRequestTimer = $routingRequestTimer;
        }
        return $this;
    }
    /**
     * Get diversionReroutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDiversionReroutingCssName()
    {
        return isset($this->diversionReroutingCssName) ? $this->diversionReroutingCssName : null;
    }
    /**
     * Set diversionReroutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setDiversionReroutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName = null)
    {
        if (is_null($diversionReroutingCssName) || (is_array($diversionReroutingCssName) && empty($diversionReroutingCssName))) {
            unset($this->diversionReroutingCssName);
        } else {
            $this->diversionReroutingCssName = $diversionReroutingCssName;
        }
        return $this;
    }
    /**
     * Get callTreatmentOnFailure value
     * @return string|null
     */
    public function getCallTreatmentOnFailure()
    {
        return $this->callTreatmentOnFailure;
    }
    /**
     * Set callTreatmentOnFailure value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callTreatmentOnFailure
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq
     */
    public function setCallTreatmentOnFailure($callTreatmentOnFailure = 'Allow Calls')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::valueIsValid($callTreatmentOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure', is_array($callTreatmentOnFailure) ? implode(', ', $callTreatmentOnFailure) : var_export($callTreatmentOnFailure, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::getValidValues())), __LINE__);
        }
        $this->callTreatmentOnFailure = $callTreatmentOnFailure;
        return $this;
    }
}
