<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDateTimeGroupReq StructType
 * @subpackage Structs
 */
class UpdateDateTimeGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - default: Europe/London
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The separator
     * Meta information extracted from the WSDL
     * - documentation: It can be one among / (slash), . (dot), - (dash)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $separator;
    /**
     * The dateformat
     * Meta information extracted from the WSDL
     * - documentation: It can be one among D/M/Y,M/D/Y,Y/M/D
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dateformat;
    /**
     * The timeFormat
     * Meta information extracted from the WSDL
     * - documentation: It can be one among 12-hour,24-hour
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeFormat;
    /**
     * The removePhoneNtpReferences
     * Meta information extracted from the WSDL
     * - choice: removePhoneNtpReferences | addPhoneNtpReferences | phoneNtpReferences
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReferences
     */
    public $removePhoneNtpReferences;
    /**
     * The addPhoneNtpReferences
     * Meta information extracted from the WSDL
     * - choice: removePhoneNtpReferences | addPhoneNtpReferences | phoneNtpReferences
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReferences
     */
    public $addPhoneNtpReferences;
    /**
     * The phoneNtpReferences
     * Meta information extracted from the WSDL
     * - choice: removePhoneNtpReferences | addPhoneNtpReferences | phoneNtpReferences
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PhoneNtpReferences
     */
    public $phoneNtpReferences;
    /**
     * Constructor method for UpdateDateTimeGroupReq
     * @uses UpdateDateTimeGroupReq::setNewName()
     * @uses UpdateDateTimeGroupReq::setTimeZone()
     * @uses UpdateDateTimeGroupReq::setSeparator()
     * @uses UpdateDateTimeGroupReq::setDateformat()
     * @uses UpdateDateTimeGroupReq::setTimeFormat()
     * @uses UpdateDateTimeGroupReq::setRemovePhoneNtpReferences()
     * @uses UpdateDateTimeGroupReq::setAddPhoneNtpReferences()
     * @uses UpdateDateTimeGroupReq::setPhoneNtpReferences()
     * @param string $newName
     * @param string $timeZone
     * @param string $separator
     * @param string $dateformat
     * @param string $timeFormat
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReferences $addPhoneNtpReferences
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PhoneNtpReferences $phoneNtpReferences
     */
    public function __construct($newName = null, $timeZone = 'Europe/London', $separator = null, $dateformat = null, $timeFormat = null, \Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences = null, \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReferences $addPhoneNtpReferences = null, \Losc\CucmBundle\Model\Webservice\StructType\PhoneNtpReferences $phoneNtpReferences = null)
    {
        $this
            ->setNewName($newName)
            ->setTimeZone($timeZone)
            ->setSeparator($separator)
            ->setDateformat($dateformat)
            ->setTimeFormat($timeFormat)
            ->setRemovePhoneNtpReferences($removePhoneNtpReferences)
            ->setAddPhoneNtpReferences($addPhoneNtpReferences)
            ->setPhoneNtpReferences($phoneNtpReferences);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setTimeZone($timeZone = 'Europe/London')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get separator value
     * @return string|null
     */
    public function getSeparator()
    {
        return $this->separator;
    }
    /**
     * Set separator value
     * @param string $separator
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setSeparator($separator = null)
    {
        // validation for constraint: string
        if (!is_null($separator) && !is_string($separator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($separator, true), gettype($separator)), __LINE__);
        }
        $this->separator = $separator;
        return $this;
    }
    /**
     * Get dateformat value
     * @return string|null
     */
    public function getDateformat()
    {
        return $this->dateformat;
    }
    /**
     * Set dateformat value
     * @param string $dateformat
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setDateformat($dateformat = null)
    {
        // validation for constraint: string
        if (!is_null($dateformat) && !is_string($dateformat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateformat, true), gettype($dateformat)), __LINE__);
        }
        $this->dateformat = $dateformat;
        return $this;
    }
    /**
     * Get timeFormat value
     * @return string|null
     */
    public function getTimeFormat()
    {
        return $this->timeFormat;
    }
    /**
     * Set timeFormat value
     * @param string $timeFormat
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setTimeFormat($timeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($timeFormat) && !is_string($timeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeFormat, true), gettype($timeFormat)), __LINE__);
        }
        $this->timeFormat = $timeFormat;
        return $this;
    }
    /**
     * Get removePhoneNtpReferences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReferences|null
     */
    public function getRemovePhoneNtpReferences()
    {
        return isset($this->removePhoneNtpReferences) ? $this->removePhoneNtpReferences : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemovePhoneNtpReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemovePhoneNtpReferences method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemovePhoneNtpReferencesForChoiceConstraintsFromSetRemovePhoneNtpReferences($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addPhoneNtpReferences',
            'phoneNtpReferences',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removePhoneNtpReferences can\'t be set as the property %s is already set. Only one property must be set among these properties: removePhoneNtpReferences, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removePhoneNtpReferences value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setRemovePhoneNtpReferences(\Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences = null)
    {
        // validation for constraint: choice(removePhoneNtpReferences, addPhoneNtpReferences, phoneNtpReferences)
        if ('' !== ($removePhoneNtpReferencesChoiceErrorMessage = self::validateRemovePhoneNtpReferencesForChoiceConstraintsFromSetRemovePhoneNtpReferences($removePhoneNtpReferences))) {
            throw new \InvalidArgumentException($removePhoneNtpReferencesChoiceErrorMessage, __LINE__);
        }
        if (is_null($removePhoneNtpReferences) || (is_array($removePhoneNtpReferences) && empty($removePhoneNtpReferences))) {
            unset($this->removePhoneNtpReferences);
        } else {
            $this->removePhoneNtpReferences = $removePhoneNtpReferences;
        }
        return $this;
    }
    /**
     * Get addPhoneNtpReferences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReferences|null
     */
    public function getAddPhoneNtpReferences()
    {
        return isset($this->addPhoneNtpReferences) ? $this->addPhoneNtpReferences : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddPhoneNtpReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddPhoneNtpReferences method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddPhoneNtpReferencesForChoiceConstraintsFromSetAddPhoneNtpReferences($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removePhoneNtpReferences',
            'phoneNtpReferences',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addPhoneNtpReferences can\'t be set as the property %s is already set. Only one property must be set among these properties: addPhoneNtpReferences, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addPhoneNtpReferences value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReferences $addPhoneNtpReferences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setAddPhoneNtpReferences(\Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReferences $addPhoneNtpReferences = null)
    {
        // validation for constraint: choice(removePhoneNtpReferences, addPhoneNtpReferences, phoneNtpReferences)
        if ('' !== ($addPhoneNtpReferencesChoiceErrorMessage = self::validateAddPhoneNtpReferencesForChoiceConstraintsFromSetAddPhoneNtpReferences($addPhoneNtpReferences))) {
            throw new \InvalidArgumentException($addPhoneNtpReferencesChoiceErrorMessage, __LINE__);
        }
        if (is_null($addPhoneNtpReferences) || (is_array($addPhoneNtpReferences) && empty($addPhoneNtpReferences))) {
            unset($this->addPhoneNtpReferences);
        } else {
            $this->addPhoneNtpReferences = $addPhoneNtpReferences;
        }
        return $this;
    }
    /**
     * Get phoneNtpReferences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PhoneNtpReferences|null
     */
    public function getPhoneNtpReferences()
    {
        return isset($this->phoneNtpReferences) ? $this->phoneNtpReferences : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPhoneNtpReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNtpReferences method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePhoneNtpReferencesForChoiceConstraintsFromSetPhoneNtpReferences($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removePhoneNtpReferences',
            'addPhoneNtpReferences',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property phoneNtpReferences can\'t be set as the property %s is already set. Only one property must be set among these properties: phoneNtpReferences, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set phoneNtpReferences value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PhoneNtpReferences $phoneNtpReferences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq
     */
    public function setPhoneNtpReferences(\Losc\CucmBundle\Model\Webservice\StructType\PhoneNtpReferences $phoneNtpReferences = null)
    {
        // validation for constraint: choice(removePhoneNtpReferences, addPhoneNtpReferences, phoneNtpReferences)
        if ('' !== ($phoneNtpReferencesChoiceErrorMessage = self::validatePhoneNtpReferencesForChoiceConstraintsFromSetPhoneNtpReferences($phoneNtpReferences))) {
            throw new \InvalidArgumentException($phoneNtpReferencesChoiceErrorMessage, __LINE__);
        }
        if (is_null($phoneNtpReferences) || (is_array($phoneNtpReferences) && empty($phoneNtpReferences))) {
            unset($this->phoneNtpReferences);
        } else {
            $this->phoneNtpReferences = $phoneNtpReferences;
        }
        return $this;
    }
}
