<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCumaServerSecurityProfileReq StructType
 * @subpackage Structs
 */
class UpdateCumaServerSecurityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $x509SubjectName;
    /**
     * The serverIpHostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serverIpHostName;
    /**
     * Constructor method for UpdateCumaServerSecurityProfileReq
     * @uses UpdateCumaServerSecurityProfileReq::setNewName()
     * @uses UpdateCumaServerSecurityProfileReq::setDescription()
     * @uses UpdateCumaServerSecurityProfileReq::setSecurityMode()
     * @uses UpdateCumaServerSecurityProfileReq::setTransportType()
     * @uses UpdateCumaServerSecurityProfileReq::setX509SubjectName()
     * @uses UpdateCumaServerSecurityProfileReq::setServerIpHostName()
     * @param string $newName
     * @param string $description
     * @param string $securityMode
     * @param string $transportType
     * @param string $x509SubjectName
     * @param string $serverIpHostName
     */
    public function __construct($newName = null, $description = null, $securityMode = null, $transportType = 'TCP+UDP', $x509SubjectName = null, $serverIpHostName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setTransportType($transportType)
            ->setX509SubjectName($x509SubjectName)
            ->setServerIpHostName($serverIpHostName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get securityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityMode()
    {
        return isset($this->securityMode) ? $this->securityMode : null;
    }
    /**
     * Set securityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode', is_array($securityMode) ? implode(', ', $securityMode) : var_export($securityMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($securityMode) || (is_array($securityMode) && empty($securityMode))) {
            unset($this->securityMode);
        } else {
            $this->securityMode = $securityMode;
        }
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTransport', is_array($transportType) ? implode(', ', $transportType) : var_export($transportType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SubjectName, true), gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get serverIpHostName value
     * @return string|null
     */
    public function getServerIpHostName()
    {
        return $this->serverIpHostName;
    }
    /**
     * Set serverIpHostName value
     * @param string $serverIpHostName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setServerIpHostName($serverIpHostName = null)
    {
        // validation for constraint: string
        if (!is_null($serverIpHostName) && !is_string($serverIpHostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverIpHostName, true), gettype($serverIpHostName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($serverIpHostName) && mb_strlen($serverIpHostName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($serverIpHostName)), __LINE__);
        }
        $this->serverIpHostName = $serverIpHostName;
        return $this;
    }
}
