<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCredentialPolicyDefaultReq StructType
 * @subpackage Structs
 */
class UpdateCredentialPolicyDefaultReq extends APIRequest
{
    /**
     * The credentialUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credentialUser;
    /**
     * The credentialType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credentialType;
    /**
     * The credPolicyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $credPolicyName;
    /**
     * The newCredPolicyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $newCredPolicyName;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $credentials;
    /**
     * The confirmCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confirmCredentials;
    /**
     * The credUserCantChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserCantChange;
    /**
     * The credUserMustChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserMustChange;
    /**
     * The credDoesNotExpire
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credDoesNotExpire;
    /**
     * Constructor method for UpdateCredentialPolicyDefaultReq
     * @uses UpdateCredentialPolicyDefaultReq::setCredentialUser()
     * @uses UpdateCredentialPolicyDefaultReq::setCredentialType()
     * @uses UpdateCredentialPolicyDefaultReq::setCredPolicyName()
     * @uses UpdateCredentialPolicyDefaultReq::setNewCredPolicyName()
     * @uses UpdateCredentialPolicyDefaultReq::setCredentials()
     * @uses UpdateCredentialPolicyDefaultReq::setConfirmCredentials()
     * @uses UpdateCredentialPolicyDefaultReq::setCredUserCantChange()
     * @uses UpdateCredentialPolicyDefaultReq::setCredUserMustChange()
     * @uses UpdateCredentialPolicyDefaultReq::setCredDoesNotExpire()
     * @param string $credentialUser
     * @param string $credentialType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $credPolicyName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $newCredPolicyName
     * @param string $credentials
     * @param string $confirmCredentials
     * @param string $credUserCantChange
     * @param string $credUserMustChange
     * @param string $credDoesNotExpire
     */
    public function __construct($credentialUser = null, $credentialType = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $credPolicyName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $newCredPolicyName = null, $credentials = null, $confirmCredentials = null, $credUserCantChange = 'false', $credUserMustChange = 'true', $credDoesNotExpire = 'false')
    {
        $this
            ->setCredentialUser($credentialUser)
            ->setCredentialType($credentialType)
            ->setCredPolicyName($credPolicyName)
            ->setNewCredPolicyName($newCredPolicyName)
            ->setCredentials($credentials)
            ->setConfirmCredentials($confirmCredentials)
            ->setCredUserCantChange($credUserCantChange)
            ->setCredUserMustChange($credUserMustChange)
            ->setCredDoesNotExpire($credDoesNotExpire);
    }
    /**
     * Get credentialUser value
     * @return string
     */
    public function getCredentialUser()
    {
        return $this->credentialUser;
    }
    /**
     * Set credentialUser value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCredentialUser::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCredentialUser::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialUser
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredentialUser($credentialUser = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCredentialUser::valueIsValid($credentialUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCredentialUser', is_array($credentialUser) ? implode(', ', $credentialUser) : var_export($credentialUser, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCredentialUser::getValidValues())), __LINE__);
        }
        $this->credentialUser = $credentialUser;
        return $this;
    }
    /**
     * Get credentialType value
     * @return string
     */
    public function getCredentialType()
    {
        return $this->credentialType;
    }
    /**
     * Set credentialType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCredential::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCredential::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredentialType($credentialType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCredential::valueIsValid($credentialType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCredential', is_array($credentialType) ? implode(', ', $credentialType) : var_export($credentialType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCredential::getValidValues())), __LINE__);
        }
        $this->credentialType = $credentialType;
        return $this;
    }
    /**
     * Get credPolicyName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCredPolicyName()
    {
        return $this->credPolicyName;
    }
    /**
     * Set credPolicyName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $credPolicyName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredPolicyName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $credPolicyName = null)
    {
        $this->credPolicyName = $credPolicyName;
        return $this;
    }
    /**
     * Get newCredPolicyName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNewCredPolicyName()
    {
        return $this->newCredPolicyName;
    }
    /**
     * Set newCredPolicyName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $newCredPolicyName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setNewCredPolicyName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newCredPolicyName = null)
    {
        $this->newCredPolicyName = $newCredPolicyName;
        return $this;
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $credentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredentials($credentials = null)
    {
        // validation for constraint: string
        if (!is_null($credentials) && !is_string($credentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credentials, true), gettype($credentials)), __LINE__);
        }
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get confirmCredentials value
     * @return string|null
     */
    public function getConfirmCredentials()
    {
        return $this->confirmCredentials;
    }
    /**
     * Set confirmCredentials value
     * @param string $confirmCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setConfirmCredentials($confirmCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($confirmCredentials) && !is_string($confirmCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmCredentials, true), gettype($confirmCredentials)), __LINE__);
        }
        $this->confirmCredentials = $confirmCredentials;
        return $this;
    }
    /**
     * Get credUserCantChange value
     * @return string|null
     */
    public function getCredUserCantChange()
    {
        return $this->credUserCantChange;
    }
    /**
     * Set credUserCantChange value
     * @param string $credUserCantChange
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredUserCantChange($credUserCantChange = 'false')
    {
        // validation for constraint: string
        if (!is_null($credUserCantChange) && !is_string($credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credUserCantChange, true), gettype($credUserCantChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credUserCantChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credUserCantChange, true)), __LINE__);
        }
        $this->credUserCantChange = $credUserCantChange;
        return $this;
    }
    /**
     * Get credUserMustChange value
     * @return string|null
     */
    public function getCredUserMustChange()
    {
        return $this->credUserMustChange;
    }
    /**
     * Set credUserMustChange value
     * @param string $credUserMustChange
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredUserMustChange($credUserMustChange = 'true')
    {
        // validation for constraint: string
        if (!is_null($credUserMustChange) && !is_string($credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credUserMustChange, true), gettype($credUserMustChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credUserMustChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credUserMustChange, true)), __LINE__);
        }
        $this->credUserMustChange = $credUserMustChange;
        return $this;
    }
    /**
     * Get credDoesNotExpire value
     * @return string|null
     */
    public function getCredDoesNotExpire()
    {
        return $this->credDoesNotExpire;
    }
    /**
     * Set credDoesNotExpire value
     * @param string $credDoesNotExpire
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq
     */
    public function setCredDoesNotExpire($credDoesNotExpire = 'false')
    {
        // validation for constraint: string
        if (!is_null($credDoesNotExpire) && !is_string($credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credDoesNotExpire, true), gettype($credDoesNotExpire)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credDoesNotExpire) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credDoesNotExpire, true)), __LINE__);
        }
        $this->credDoesNotExpire = $credDoesNotExpire;
        return $this;
    }
}
