<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCiscoCatalyst6000T1VoIPGatewayPriReq StructType
 * @subpackage Structs
 */
class UpdateCiscoCatalyst6000T1VoIPGatewayPriReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The mlppPreemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppPreemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The calledPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPri;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPri;
    /**
     * The chanIe
     * Meta information extracted from the WSDL
     * - default: Use Number when 1B
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $chanIe;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clockReference;
    /**
     * The dChannelEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta information extracted from the WSDL
     * - default: Top Down
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The displayIE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIE;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pcmType;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $csuParam;
    /**
     * The firstDelay
     * Meta information extracted from the WSDL
     * - default: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $firstDelay;
    /**
     * The interfaceIdPresent
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $interfaceIdPresent;
    /**
     * The interfaceId
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $interfaceId;
    /**
     * The intraDelay
     * Meta information extracted from the WSDL
     * - default: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $intraDelay;
    /**
     * The mcdnEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mcdnEnable;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The passingPrecedenceLevelThrough
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $passingPrecedenceLevelThrough;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefix;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The connectedLineIdPresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedLineIdPresentation;
    /**
     * The priProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $priProtocol;
    /**
     * The securityAccessLevel
     * Meta information extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $securityAccessLevel;
    /**
     * The sendCallingNameInFacilityIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendCallingNameInFacilityIe;
    /**
     * The sendExLeadingCharInDispIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendExLeadingCharInDispIe;
    /**
     * The sendRestart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The span
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $span;
    /**
     * The statusPoll
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The smdiBasePort
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $smdiBasePort;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The v150
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $v150;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only if PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The QSIGVariant
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $QSIGVariant;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * Constructor method for UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNewName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setDescription()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCallingSearchSpaceName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setDevicePoolName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCommonDeviceConfigName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNetworkLocation()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setLocationName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNetworkLocale()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setMediaResourceListName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setAarNeighborhoodName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setLoadInformation()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setVendorConfig()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setMlppDomainId()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setMlppIndicationStatus()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setMlppPreemption()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseTrustedRelayPoint()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCgpnTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseDevicePoolCgpnTransformCss()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setGeoLocationName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setRedirectInboundNumberIe()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCalledPlan()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCalledPri()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCallerIdDn()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCallingPartySelection()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCallingPlan()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCallingPri()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setChanIe()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setClockReference()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setDChannelEnable()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setChannelSelectionOrder()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setDisplayIE()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPcmType()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCsuParam()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setFirstDelay()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setInterfaceIdPresent()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setInterfaceId()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setIntraDelay()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setMcdnEnable()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setRedirectOutboundNumberIe()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNumDigitsToStrip()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPassingPrecedenceLevelThrough()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPrefix()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCallingLinePresentationBit()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setConnectedLineIdPresentation()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPriProtocol()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSecurityAccessLevel()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSendCallingNameInFacilityIe()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSendExLeadingCharInDispIe()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSendRestart()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSetupNonIsdnPi()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSigDigits()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSpan()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setStatusPoll()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSmdiBasePort()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPacketCaptureMode()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPacketCaptureDuration()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setTransmitUtf8()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setV150()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setAsn1RoseOidEncoding()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setQSIGVariant()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUnattendedPort()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setCdpnTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseDevicePoolCdpnTransformCss()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNationalPrefix()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setInternationalPrefix()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUnknownPrefix()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSubscriberPrefix()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setGeoLocationFilterName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNationalStripDigits()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setInternationalStripDigits()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUnknownStripDigits()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSubscriberStripDigits()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setNationalTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setInternationalTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUnknownTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setSubscriberTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseDevicePoolCgpnTransformCssNatl()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseDevicePoolCgpnTransformCssIntl()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setUseDevicePoolCgpnTransformCssSubs()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setPstnAccess()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayPriReq::setImeE164TransformationName()
     * @param string $newName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $networkLocale
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $mlppPreemption
     * @param string $useTrustedRelayPoint
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $redirectInboundNumberIe
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $chanIe
     * @param string $clockReference
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $displayIE
     * @param string $pcmType
     * @param string $csuParam
     * @param string $firstDelay
     * @param string $interfaceIdPresent
     * @param string $interfaceId
     * @param string $intraDelay
     * @param string $mcdnEnable
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $passingPrecedenceLevelThrough
     * @param string $prefix
     * @param string $callingLinePresentationBit
     * @param string $connectedLineIdPresentation
     * @param string $priProtocol
     * @param string $securityAccessLevel
     * @param string $sendCallingNameInFacilityIe
     * @param string $sendExLeadingCharInDispIe
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $span
     * @param string $statusPoll
     * @param string $smdiBasePort
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $transmitUtf8
     * @param string $v150
     * @param string $asn1RoseOidEncoding
     * @param string $qSIGVariant
     * @param string $unattendedPort
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $pstnAccess
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     */
    public function __construct($newName = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $networkLocale = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $mlppPreemption = 'Default', $useTrustedRelayPoint = 'Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = 'true', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $redirectInboundNumberIe = null, $calledPlan = 'Cisco CallManager', $calledPri = 'Cisco CallManager', $callerIdDn = null, $callingPartySelection = 'Originator', $callingPlan = 'Cisco CallManager', $callingPri = 'Cisco CallManager', $chanIe = 'Use Number when 1B', $clockReference = null, $dChannelEnable = null, $channelSelectionOrder = 'Top Down', $displayIE = null, $pcmType = null, $csuParam = null, $firstDelay = '32', $interfaceIdPresent = null, $interfaceId = '0', $intraDelay = '4', $mcdnEnable = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = '0', $passingPrecedenceLevelThrough = null, $prefix = null, $callingLinePresentationBit = 'Default', $connectedLineIdPresentation = 'Default', $priProtocol = null, $securityAccessLevel = '2', $sendCallingNameInFacilityIe = null, $sendExLeadingCharInDispIe = null, $sendRestart = null, $setupNonIsdnPi = null, \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $span = null, $statusPoll = null, $smdiBasePort = '0', $packetCaptureMode = 'None', $packetCaptureDuration = '0', $transmitUtf8 = 'false', $v150 = 'false', $asn1RoseOidEncoding = 'No Changes', $qSIGVariant = 'No Changes', $unattendedPort = 'false', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = 'true', $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null, $useDevicePoolCgpnTransformCssNatl = 'true', $useDevicePoolCgpnTransformCssIntl = 'true', $useDevicePoolCgpnTransformCssUnkn = 'true', $useDevicePoolCgpnTransformCssSubs = 'true', $pstnAccess = 'true', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setNetworkLocale($networkLocale)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setMlppPreemption($mlppPreemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setChanIe($chanIe)
            ->setClockReference($clockReference)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setDisplayIE($displayIE)
            ->setPcmType($pcmType)
            ->setCsuParam($csuParam)
            ->setFirstDelay($firstDelay)
            ->setInterfaceIdPresent($interfaceIdPresent)
            ->setInterfaceId($interfaceId)
            ->setIntraDelay($intraDelay)
            ->setMcdnEnable($mcdnEnable)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPassingPrecedenceLevelThrough($passingPrecedenceLevelThrough)
            ->setPrefix($prefix)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setConnectedLineIdPresentation($connectedLineIdPresentation)
            ->setPriProtocol($priProtocol)
            ->setSecurityAccessLevel($securityAccessLevel)
            ->setSendCallingNameInFacilityIe($sendCallingNameInFacilityIe)
            ->setSendExLeadingCharInDispIe($sendExLeadingCharInDispIe)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setSpan($span)
            ->setStatusPoll($statusPoll)
            ->setSmdiBasePort($smdiBasePort)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setTransmitUtf8($transmitUtf8)
            ->setV150($v150)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQSIGVariant($qSIGVariant)
            ->setUnattendedPort($unattendedPort)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($newName) && mb_strlen($newName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCountry::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCountry', is_array($networkLocale) ? implode(', ', $networkLocale) : var_export($networkLocale, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setMediaResourceListName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setAutomatedAlternateRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setLoadInformation(\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setVendorConfig(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppDomainId, true), gettype($mlppDomainId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mlppDomainId) && mb_strlen($mlppDomainId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string|null
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppPreemption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setMlppPreemption($mlppPreemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid($mlppPreemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption', is_array($mlppPreemption) ? implode(', ', $mlppPreemption) : var_export($mlppPreemption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCgpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setGeoLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectInboundNumberIe, true), gettype($redirectInboundNumberIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string|null
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCalledPlan($calledPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($calledPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($calledPlan) ? implode(', ', $calledPlan) : var_export($calledPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string|null
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCalledPri($calledPri = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($calledPri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($calledPri) ? implode(', ', $calledPri) : var_export($calledPri, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection', is_array($callingPartySelection) ? implode(', ', $callingPartySelection) : var_export($callingPartySelection, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string|null
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCallingPlan($callingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($callingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($callingPlan) ? implode(', ', $callingPlan) : var_export($callingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string|null
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCallingPri($callingPri = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($callingPri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($callingPri) ? implode(', ', $callingPri) : var_export($callingPri, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get chanIe value
     * @return string|null
     */
    public function getChanIe()
    {
        return $this->chanIe;
    }
    /**
     * Set chanIe value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPRIChanIE::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPRIChanIE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chanIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setChanIe($chanIe = 'Use Number when 1B')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPRIChanIE::valueIsValid($chanIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPRIChanIE', is_array($chanIe) ? implode(', ', $chanIe) : var_export($chanIe, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPRIChanIE::getValidValues())), __LINE__);
        }
        $this->chanIe = $chanIe;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference', is_array($clockReference) ? implode(', ', $clockReference) : var_export($clockReference, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string|null
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        // validation for constraint: string
        if (!is_null($dChannelEnable) && !is_string($dChannelEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dChannelEnable, true), gettype($dChannelEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($dChannelEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dChannelEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($dChannelEnable, true)), __LINE__);
        }
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string|null
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channelSelectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setChannelSelectionOrder($channelSelectionOrder = 'Top Down')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::valueIsValid($channelSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder', is_array($channelSelectionOrder) ? implode(', ', $channelSelectionOrder) : var_export($channelSelectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get displayIE value
     * @return string|null
     */
    public function getDisplayIE()
    {
        return $this->displayIE;
    }
    /**
     * Set displayIE value
     * @param string $displayIE
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setDisplayIE($displayIE = null)
    {
        // validation for constraint: string
        if (!is_null($displayIE) && !is_string($displayIE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayIE, true), gettype($displayIE)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($displayIE) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayIE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($displayIE, true)), __LINE__);
        }
        $this->displayIE = $displayIE;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XEncode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XEncode', is_array($pcmType) ? implode(', ', $pcmType) : var_export($pcmType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam', is_array($csuParam) ? implode(', ', $csuParam) : var_export($csuParam, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string|null
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstDelay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setFirstDelay($firstDelay = '32')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($firstDelay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($firstDelay) ? implode(', ', $firstDelay) : var_export($firstDelay, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get interfaceIdPresent value
     * @return string|null
     */
    public function getInterfaceIdPresent()
    {
        return $this->interfaceIdPresent;
    }
    /**
     * Set interfaceIdPresent value
     * @param string $interfaceIdPresent
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setInterfaceIdPresent($interfaceIdPresent = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceIdPresent) && !is_string($interfaceIdPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfaceIdPresent, true), gettype($interfaceIdPresent)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($interfaceIdPresent) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $interfaceIdPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($interfaceIdPresent, true)), __LINE__);
        }
        $this->interfaceIdPresent = $interfaceIdPresent;
        return $this;
    }
    /**
     * Get interfaceId value
     * @return string|null
     */
    public function getInterfaceId()
    {
        return $this->interfaceId;
    }
    /**
     * Set interfaceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interfaceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setInterfaceId($interfaceId = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($interfaceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($interfaceId) ? implode(', ', $interfaceId) : var_export($interfaceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->interfaceId = $interfaceId;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string|null
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intraDelay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setIntraDelay($intraDelay = '4')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($intraDelay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($intraDelay) ? implode(', ', $intraDelay) : var_export($intraDelay, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get mcdnEnable value
     * @return string|null
     */
    public function getMcdnEnable()
    {
        return $this->mcdnEnable;
    }
    /**
     * Set mcdnEnable value
     * @param string $mcdnEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setMcdnEnable($mcdnEnable = null)
    {
        // validation for constraint: string
        if (!is_null($mcdnEnable) && !is_string($mcdnEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mcdnEnable, true), gettype($mcdnEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($mcdnEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mcdnEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($mcdnEnable, true)), __LINE__);
        }
        $this->mcdnEnable = $mcdnEnable;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectOutboundNumberIe, true), gettype($redirectOutboundNumberIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string|null
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numDigitsToStrip
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNumDigitsToStrip($numDigitsToStrip = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numDigitsToStrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numDigitsToStrip) ? implode(', ', $numDigitsToStrip) : var_export($numDigitsToStrip, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get passingPrecedenceLevelThrough value
     * @return string|null
     */
    public function getPassingPrecedenceLevelThrough()
    {
        return $this->passingPrecedenceLevelThrough;
    }
    /**
     * Set passingPrecedenceLevelThrough value
     * @param string $passingPrecedenceLevelThrough
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPassingPrecedenceLevelThrough($passingPrecedenceLevelThrough = null)
    {
        // validation for constraint: string
        if (!is_null($passingPrecedenceLevelThrough) && !is_string($passingPrecedenceLevelThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passingPrecedenceLevelThrough, true), gettype($passingPrecedenceLevelThrough)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($passingPrecedenceLevelThrough) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $passingPrecedenceLevelThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($passingPrecedenceLevelThrough, true)), __LINE__);
        }
        $this->passingPrecedenceLevelThrough = $passingPrecedenceLevelThrough;
        return $this;
    }
    /**
     * Get prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->prefix) ? $this->prefix : null;
    }
    /**
     * Set prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->prefix);
        } else {
            $this->prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLinePresentationBit) ? implode(', ', $callingLinePresentationBit) : var_export($callingLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedLineIdPresentation value
     * @return string|null
     */
    public function getConnectedLineIdPresentation()
    {
        return $this->connectedLineIdPresentation;
    }
    /**
     * Set connectedLineIdPresentation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLineIdPresentation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setConnectedLineIdPresentation($connectedLineIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedLineIdPresentation) ? implode(', ', $connectedLineIdPresentation) : var_export($connectedLineIdPresentation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLineIdPresentation = $connectedLineIdPresentation;
        return $this;
    }
    /**
     * Get priProtocol value
     * @return string|null
     */
    public function getPriProtocol()
    {
        return $this->priProtocol;
    }
    /**
     * Set priProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPriProtocol($priProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::valueIsValid($priProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol', is_array($priProtocol) ? implode(', ', $priProtocol) : var_export($priProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::getValidValues())), __LINE__);
        }
        $this->priProtocol = $priProtocol;
        return $this;
    }
    /**
     * Get securityAccessLevel value
     * @return string|null
     */
    public function getSecurityAccessLevel()
    {
        return $this->securityAccessLevel;
    }
    /**
     * Set securityAccessLevel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityAccessLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSecurityAccessLevel($securityAccessLevel = '2')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($securityAccessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($securityAccessLevel) ? implode(', ', $securityAccessLevel) : var_export($securityAccessLevel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->securityAccessLevel = $securityAccessLevel;
        return $this;
    }
    /**
     * Get sendCallingNameInFacilityIe value
     * @return string|null
     */
    public function getSendCallingNameInFacilityIe()
    {
        return $this->sendCallingNameInFacilityIe;
    }
    /**
     * Set sendCallingNameInFacilityIe value
     * @param string $sendCallingNameInFacilityIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSendCallingNameInFacilityIe($sendCallingNameInFacilityIe = null)
    {
        // validation for constraint: string
        if (!is_null($sendCallingNameInFacilityIe) && !is_string($sendCallingNameInFacilityIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendCallingNameInFacilityIe, true), gettype($sendCallingNameInFacilityIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendCallingNameInFacilityIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendCallingNameInFacilityIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendCallingNameInFacilityIe, true)), __LINE__);
        }
        $this->sendCallingNameInFacilityIe = $sendCallingNameInFacilityIe;
        return $this;
    }
    /**
     * Get sendExLeadingCharInDispIe value
     * @return string|null
     */
    public function getSendExLeadingCharInDispIe()
    {
        return $this->sendExLeadingCharInDispIe;
    }
    /**
     * Set sendExLeadingCharInDispIe value
     * @param string $sendExLeadingCharInDispIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSendExLeadingCharInDispIe($sendExLeadingCharInDispIe = null)
    {
        // validation for constraint: string
        if (!is_null($sendExLeadingCharInDispIe) && !is_string($sendExLeadingCharInDispIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendExLeadingCharInDispIe, true), gettype($sendExLeadingCharInDispIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendExLeadingCharInDispIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendExLeadingCharInDispIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendExLeadingCharInDispIe, true)), __LINE__);
        }
        $this->sendExLeadingCharInDispIe = $sendExLeadingCharInDispIe;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string|null
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSendRestart($sendRestart = null)
    {
        // validation for constraint: string
        if (!is_null($sendRestart) && !is_string($sendRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendRestart, true), gettype($sendRestart)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendRestart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendRestart, true)), __LINE__);
        }
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string|null
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        // validation for constraint: string
        if (!is_null($setupNonIsdnPi) && !is_string($setupNonIsdnPi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($setupNonIsdnPi, true), gettype($setupNonIsdnPi)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($setupNonIsdnPi) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $setupNonIsdnPi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($setupNonIsdnPi, true)), __LINE__);
        }
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSigDigits(\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get span value
     * @return string|null
     */
    public function getSpan()
    {
        return $this->span;
    }
    /**
     * Set span value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $span
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSpan($span = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($span)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($span) ? implode(', ', $span) : var_export($span, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->span = $span;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string|null
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setStatusPoll($statusPoll = null)
    {
        // validation for constraint: string
        if (!is_null($statusPoll) && !is_string($statusPoll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusPoll, true), gettype($statusPoll)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($statusPoll) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $statusPoll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($statusPoll, true)), __LINE__);
        }
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string|null
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smdiBasePort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSmdiBasePort($smdiBasePort = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($smdiBasePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($smdiBasePort) ? implode(', ', $smdiBasePort) : var_export($smdiBasePort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode', is_array($packetCaptureMode) ? implode(', ', $packetCaptureMode) : var_export($packetCaptureMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($packetCaptureDuration) ? implode(', ', $packetCaptureDuration) : var_export($packetCaptureDuration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setTransmitUtf8($transmitUtf8 = 'false')
    {
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitUtf8, true), gettype($transmitUtf8)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($transmitUtf8, true)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get v150 value
     * @return string|null
     */
    public function getV150()
    {
        return $this->v150;
    }
    /**
     * Set v150 value
     * @param string $v150
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setV150($v150 = 'false')
    {
        // validation for constraint: string
        if (!is_null($v150) && !is_string($v150)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v150, true), gettype($v150)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($v150) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $v150)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($v150, true)), __LINE__);
        }
        $this->v150 = $v150;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding', is_array($asn1RoseOidEncoding) ? implode(', ', $asn1RoseOidEncoding) : var_export($asn1RoseOidEncoding, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get QSIGVariant value
     * @return string|null
     */
    public function getQSIGVariant()
    {
        return $this->QSIGVariant;
    }
    /**
     * Set QSIGVariant value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qSIGVariant
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setQSIGVariant($qSIGVariant = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::valueIsValid($qSIGVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant', is_array($qSIGVariant) ? implode(', ', $qSIGVariant) : var_export($qSIGVariant, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->QSIGVariant = $qSIGVariant;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUnattendedPort($unattendedPort = 'false')
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setCdpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCdpnTransformCss, true), gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalPrefix, true), gettype($nationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($nationalPrefix) && mb_strlen($nationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalPrefix, true), gettype($internationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($internationalPrefix) && mb_strlen($internationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unknownPrefix, true), gettype($unknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unknownPrefix) && mb_strlen($unknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberPrefix, true), gettype($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($subscriberPrefix) && mb_strlen($subscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setGeoLocationFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return isset($this->nationalStripDigits) ? $this->nationalStripDigits : null;
    }
    /**
     * Set nationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nationalStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($nationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($nationalStripDigits) ? implode(', ', $nationalStripDigits) : var_export($nationalStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($nationalStripDigits) || (is_array($nationalStripDigits) && empty($nationalStripDigits))) {
            unset($this->nationalStripDigits);
        } else {
            $this->nationalStripDigits = $nationalStripDigits;
        }
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return isset($this->internationalStripDigits) ? $this->internationalStripDigits : null;
    }
    /**
     * Set internationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internationalStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($internationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($internationalStripDigits) ? implode(', ', $internationalStripDigits) : var_export($internationalStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($internationalStripDigits) || (is_array($internationalStripDigits) && empty($internationalStripDigits))) {
            unset($this->internationalStripDigits);
        } else {
            $this->internationalStripDigits = $internationalStripDigits;
        }
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($unknownStripDigits) ? implode(', ', $unknownStripDigits) : var_export($unknownStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return isset($this->subscriberStripDigits) ? $this->subscriberStripDigits : null;
    }
    /**
     * Set subscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($subscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($subscriberStripDigits) ? implode(', ', $subscriberStripDigits) : var_export($subscriberStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($subscriberStripDigits) || (is_array($subscriberStripDigits) && empty($subscriberStripDigits))) {
            unset($this->subscriberStripDigits);
        } else {
            $this->subscriberStripDigits = $subscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return isset($this->nationalTransformationCssName) ? $this->nationalTransformationCssName : null;
    }
    /**
     * Set nationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setNationalTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null)
    {
        if (is_null($nationalTransformationCssName) || (is_array($nationalTransformationCssName) && empty($nationalTransformationCssName))) {
            unset($this->nationalTransformationCssName);
        } else {
            $this->nationalTransformationCssName = $nationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return isset($this->internationalTransformationCssName) ? $this->internationalTransformationCssName : null;
    }
    /**
     * Set internationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setInternationalTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null)
    {
        if (is_null($internationalTransformationCssName) || (is_array($internationalTransformationCssName) && empty($internationalTransformationCssName))) {
            unset($this->internationalTransformationCssName);
        } else {
            $this->internationalTransformationCssName = $internationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return isset($this->unknownTransformationCssName) ? $this->unknownTransformationCssName : null;
    }
    /**
     * Set unknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUnknownTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null)
    {
        if (is_null($unknownTransformationCssName) || (is_array($unknownTransformationCssName) && empty($unknownTransformationCssName))) {
            unset($this->unknownTransformationCssName);
        } else {
            $this->unknownTransformationCssName = $unknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return isset($this->subscriberTransformationCssName) ? $this->subscriberTransformationCssName : null;
    }
    /**
     * Set subscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setSubscriberTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null)
    {
        if (is_null($subscriberTransformationCssName) || (is_array($subscriberTransformationCssName) && empty($subscriberTransformationCssName))) {
            unset($this->subscriberTransformationCssName);
        } else {
            $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !is_string($useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssNatl, true), gettype($useDevicePoolCgpnTransformCssNatl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssNatl, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !is_string($useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssIntl, true), gettype($useDevicePoolCgpnTransformCssIntl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssIntl, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssUnkn, true), gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !is_string($useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssSubs, true), gettype($useDevicePoolCgpnTransformCssSubs)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssSubs, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setPstnAccess($pstnAccess = 'true')
    {
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnAccess, true), gettype($pstnAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pstnAccess, true)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq
     */
    public function setImeE164TransformationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
}
