<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCallPickupGroupReq StructType
 * @subpackage Structs
 */
class UpdateCallPickupGroupReq extends APIRequest
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - choice: uuid | name | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | name | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | name | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - choice: uuid | name | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The removeMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The pickupNotification
     * Meta information extracted from the WSDL
     * - default: No Alert
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pickupNotification;
    /**
     * The pickupNotificationTimer
     * Meta information extracted from the WSDL
     * - default: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pickupNotificationTimer;
    /**
     * The callInfoForPickupNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CallInfoForPickupNotification
     */
    public $callInfoForPickupNotification;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * Constructor method for UpdateCallPickupGroupReq
     * @uses UpdateCallPickupGroupReq::setName()
     * @uses UpdateCallPickupGroupReq::setPattern()
     * @uses UpdateCallPickupGroupReq::setUuid()
     * @uses UpdateCallPickupGroupReq::setRoutePartitionName()
     * @uses UpdateCallPickupGroupReq::setNewPattern()
     * @uses UpdateCallPickupGroupReq::setDescription()
     * @uses UpdateCallPickupGroupReq::setNewRoutePartitionName()
     * @uses UpdateCallPickupGroupReq::setRemoveMembers()
     * @uses UpdateCallPickupGroupReq::setAddMembers()
     * @uses UpdateCallPickupGroupReq::setMembers()
     * @uses UpdateCallPickupGroupReq::setPickupNotification()
     * @uses UpdateCallPickupGroupReq::setPickupNotificationTimer()
     * @uses UpdateCallPickupGroupReq::setCallInfoForPickupNotification()
     * @uses UpdateCallPickupGroupReq::setNewName()
     * @param string $name
     * @param string $pattern
     * @param string $uuid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $newPattern
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $pickupNotification
     * @param string $pickupNotificationTimer
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CallInfoForPickupNotification $callInfoForPickupNotification
     * @param string $newName
     */
    public function __construct($name = null, $pattern = null, $uuid = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $newPattern = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers = null, \Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $pickupNotification = 'No Alert', $pickupNotificationTimer = '6', \Losc\CucmBundle\Model\Webservice\StructType\CallInfoForPickupNotification $callInfoForPickupNotification = null, $newName = null)
    {
        $this
            ->setName($name)
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setPickupNotification($pickupNotification)
            ->setPickupNotificationTimer($pickupNotificationTimer)
            ->setCallInfoForPickupNotification($callInfoForPickupNotification)
            ->setNewName($newName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNameForChoiceConstraintsFromSetName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'pattern',
            'routePartitionName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property name can\'t be set as the property %s is already set. Only one property must be set among these properties: name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: choice(uuid, name, pattern, routePartitionName)
        if ('' !== ($nameChoiceErrorMessage = self::validateNameForChoiceConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameChoiceErrorMessage, __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternForChoiceConstraintsFromSetPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'name',
            'routePartitionName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pattern can\'t be set as the property %s is already set. Only one property must be set among these properties: pattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, name, pattern, routePartitionName)
        if ('' !== ($patternChoiceErrorMessage = self::validatePatternForChoiceConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternChoiceErrorMessage, __LINE__);
        }
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'name',
            'pattern',
            'routePartitionName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, name, pattern, routePartitionName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRoutePartitionName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoutePartitionName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRoutePartitionNameForChoiceConstraintsFromSetRoutePartitionName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'name',
            'pattern',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property routePartitionName can\'t be set as the property %s is already set. Only one property must be set among these properties: routePartitionName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        // validation for constraint: choice(uuid, name, pattern, routePartitionName)
        if ('' !== ($routePartitionNameChoiceErrorMessage = self::validateRoutePartitionNameForChoiceConstraintsFromSetRoutePartitionName($routePartitionName))) {
            throw new \InvalidArgumentException($routePartitionNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPattern, true), gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setNewRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return isset($this->removeMembers) ? $this->removeMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: removeMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setRemoveMembers(\Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($removeMembersChoiceErrorMessage = self::validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($removeMembers))) {
            throw new \InvalidArgumentException($removeMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeMembers) || (is_array($removeMembers) && empty($removeMembers))) {
            unset($this->removeMembers);
        } else {
            $this->removeMembers = $removeMembers;
        }
        return $this;
    }
    /**
     * Get addMembers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return isset($this->addMembers) ? $this->addMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddMembersForChoiceConstraintsFromSetAddMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: addMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setAddMembers(\Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($addMembersChoiceErrorMessage = self::validateAddMembersForChoiceConstraintsFromSetAddMembers($addMembers))) {
            throw new \InvalidArgumentException($addMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($addMembers) || (is_array($addMembers) && empty($addMembers))) {
            unset($this->addMembers);
        } else {
            $this->addMembers = $addMembers;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMembersForChoiceConstraintsFromSetMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'addMembers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property members can\'t be set as the property %s is already set. Only one property must be set among these properties: members, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set members value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($membersChoiceErrorMessage = self::validateMembersForChoiceConstraintsFromSetMembers($members))) {
            throw new \InvalidArgumentException($membersChoiceErrorMessage, __LINE__);
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Get pickupNotification value
     * @return string|null
     */
    public function getPickupNotification()
    {
        return $this->pickupNotification;
    }
    /**
     * Set pickupNotification value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPickupNotification::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPickupNotification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotification
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setPickupNotification($pickupNotification = 'No Alert')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPickupNotification::valueIsValid($pickupNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPickupNotification', is_array($pickupNotification) ? implode(', ', $pickupNotification) : var_export($pickupNotification, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPickupNotification::getValidValues())), __LINE__);
        }
        $this->pickupNotification = $pickupNotification;
        return $this;
    }
    /**
     * Get pickupNotificationTimer value
     * @return string|null
     */
    public function getPickupNotificationTimer()
    {
        return $this->pickupNotificationTimer;
    }
    /**
     * Set pickupNotificationTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotificationTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setPickupNotificationTimer($pickupNotificationTimer = '6')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($pickupNotificationTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($pickupNotificationTimer) ? implode(', ', $pickupNotificationTimer) : var_export($pickupNotificationTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pickupNotificationTimer = $pickupNotificationTimer;
        return $this;
    }
    /**
     * Get callInfoForPickupNotification value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CallInfoForPickupNotification|null
     */
    public function getCallInfoForPickupNotification()
    {
        return $this->callInfoForPickupNotification;
    }
    /**
     * Set callInfoForPickupNotification value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CallInfoForPickupNotification $callInfoForPickupNotification
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setCallInfoForPickupNotification(\Losc\CucmBundle\Model\Webservice\StructType\CallInfoForPickupNotification $callInfoForPickupNotification = null)
    {
        $this->callInfoForPickupNotification = $callInfoForPickupNotification;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
}
