<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sipPorts StructType
 * @subpackage Structs
 */
class SipPorts extends AbstractStructBase
{
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhonePort;
    /**
     * The sipPhoneSecurePort
     * Meta information extracted from the WSDL
     * - default: 5061
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhoneSecurePort;
    /**
     * Constructor method for sipPorts
     * @uses SipPorts::setSipPhonePort()
     * @uses SipPorts::setSipPhoneSecurePort()
     * @param string $sipPhonePort
     * @param string $sipPhoneSecurePort
     */
    public function __construct($sipPhonePort = '5060', $sipPhoneSecurePort = '5061')
    {
        $this
            ->setSipPhonePort($sipPhonePort)
            ->setSipPhoneSecurePort($sipPhoneSecurePort);
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhonePort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\SipPorts
     */
    public function setSipPhonePort($sipPhonePort = '5060')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($sipPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($sipPhonePort) ? implode(', ', $sipPhonePort) : var_export($sipPhonePort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get sipPhoneSecurePort value
     * @return string|null
     */
    public function getSipPhoneSecurePort()
    {
        return $this->sipPhoneSecurePort;
    }
    /**
     * Set sipPhoneSecurePort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhoneSecurePort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\SipPorts
     */
    public function setSipPhoneSecurePort($sipPhoneSecurePort = '5061')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($sipPhoneSecurePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($sipPhoneSecurePort) ? implode(', ', $sipPhoneSecurePort) : var_export($sipPhoneSecurePort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhoneSecurePort = $sipPhoneSecurePort;
        return $this;
    }
}
