<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVoiceMailPort StructType
 * @subpackage Structs
 */
class RVoiceMailPort extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The dnPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dnPattern;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartition;
    /**
     * The dnCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dnCallingSearchSpace;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callerIdDisplay
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDisplay;
    /**
     * The callerIdDisplayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDisplayAscii;
    /**
     * The externalMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalMask;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RVoiceMailPort
     * @uses RVoiceMailPort::setName()
     * @uses RVoiceMailPort::setDescription()
     * @uses RVoiceMailPort::setProduct()
     * @uses RVoiceMailPort::setModel()
     * @uses RVoiceMailPort::setClass()
     * @uses RVoiceMailPort::setProtocol()
     * @uses RVoiceMailPort::setProtocolSide()
     * @uses RVoiceMailPort::setCallingSearchSpaceName()
     * @uses RVoiceMailPort::setDevicePoolName()
     * @uses RVoiceMailPort::setCommonDeviceConfigName()
     * @uses RVoiceMailPort::setLocationName()
     * @uses RVoiceMailPort::setPreemption()
     * @uses RVoiceMailPort::setUseTrustedRelayPoint()
     * @uses RVoiceMailPort::setSecurityProfileName()
     * @uses RVoiceMailPort::setGeoLocationName()
     * @uses RVoiceMailPort::setAutomatedAlternateRoutingCssName()
     * @uses RVoiceMailPort::setDnPattern()
     * @uses RVoiceMailPort::setRoutePartition()
     * @uses RVoiceMailPort::setDnCallingSearchSpace()
     * @uses RVoiceMailPort::setAarNeighborhoodName()
     * @uses RVoiceMailPort::setCallerIdDisplay()
     * @uses RVoiceMailPort::setCallerIdDisplayAscii()
     * @uses RVoiceMailPort::setExternalMask()
     * @uses RVoiceMailPort::setCtiid()
     * @uses RVoiceMailPort::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param string $dnPattern
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $callerIdDisplay
     * @param string $callerIdDisplayAscii
     * @param string $externalMask
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $preemption = null, $useTrustedRelayPoint = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, $dnPattern = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $callerIdDisplay = null, $callerIdDisplayAscii = null, $externalMask = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setGeoLocationName($geoLocationName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setDnPattern($dnPattern)
            ->setRoutePartition($routePartition)
            ->setDnCallingSearchSpace($dnCallingSearchSpace)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallerIdDisplay($callerIdDisplay)
            ->setCallerIdDisplayAscii($callerIdDisplayAscii)
            ->setExternalMask($externalMask)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setSecurityProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setGeoLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setAutomatedAlternateRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get dnPattern value
     * @return string|null
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setDnPattern($dnPattern = null)
    {
        // validation for constraint: string
        if (!is_null($dnPattern) && !is_string($dnPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnPattern, true), gettype($dnPattern)), __LINE__);
        }
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get routePartition value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setRoutePartition(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition = null)
    {
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get dnCallingSearchSpace value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDnCallingSearchSpace()
    {
        return $this->dnCallingSearchSpace;
    }
    /**
     * Set dnCallingSearchSpace value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setDnCallingSearchSpace(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCallingSearchSpace = null)
    {
        $this->dnCallingSearchSpace = $dnCallingSearchSpace;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get callerIdDisplay value
     * @return string|null
     */
    public function getCallerIdDisplay()
    {
        return $this->callerIdDisplay;
    }
    /**
     * Set callerIdDisplay value
     * @param string $callerIdDisplay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setCallerIdDisplay($callerIdDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDisplay) && !is_string($callerIdDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDisplay, true), gettype($callerIdDisplay)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callerIdDisplay) && mb_strlen($callerIdDisplay) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callerIdDisplay)), __LINE__);
        }
        $this->callerIdDisplay = $callerIdDisplay;
        return $this;
    }
    /**
     * Get callerIdDisplayAscii value
     * @return string|null
     */
    public function getCallerIdDisplayAscii()
    {
        return $this->callerIdDisplayAscii;
    }
    /**
     * Set callerIdDisplayAscii value
     * @param string $callerIdDisplayAscii
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setCallerIdDisplayAscii($callerIdDisplayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDisplayAscii) && !is_string($callerIdDisplayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDisplayAscii, true), gettype($callerIdDisplayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDisplayAscii) && mb_strlen($callerIdDisplayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDisplayAscii)), __LINE__);
        }
        $this->callerIdDisplayAscii = $callerIdDisplayAscii;
        return $this;
    }
    /**
     * Get externalMask value
     * @return string|null
     */
    public function getExternalMask()
    {
        return $this->externalMask;
    }
    /**
     * Set externalMask value
     * @param string $externalMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setExternalMask($externalMask = null)
    {
        // validation for constraint: string
        if (!is_null($externalMask) && !is_string($externalMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalMask, true), gettype($externalMask)), __LINE__);
        }
        $this->externalMask = $externalMask;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPort
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
