<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUcService StructType
 * @subpackage Structs
 */
class RUcService extends AbstractStructBase
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The hostnameorip
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostnameorip;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence) and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence),CTI and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The ucServiceXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $ucServiceXml;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUcService
     * @uses RUcService::setServiceType()
     * @uses RUcService::setProductType()
     * @uses RUcService::setName()
     * @uses RUcService::setDescription()
     * @uses RUcService::setHostnameorip()
     * @uses RUcService::setPort()
     * @uses RUcService::setProtocol()
     * @uses RUcService::setUcServiceXml()
     * @uses RUcService::setUuid()
     * @param string $serviceType
     * @param string $productType
     * @param string $name
     * @param string $description
     * @param string $hostnameorip
     * @param string $port
     * @param string $protocol
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml
     * @param string $uuid
     */
    public function __construct($serviceType = null, $productType = null, $name = null, $description = null, $hostnameorip = null, $port = null, $protocol = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml = null, $uuid = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setProductType($productType)
            ->setName($name)
            ->setDescription($description)
            ->setHostnameorip($hostnameorip)
            ->setPort($port)
            ->setProtocol($protocol)
            ->setUcServiceXml($ucServiceXml)
            ->setUuid($uuid);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUCService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUCService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUCService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUCService', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUCService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUCProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUCProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUCProduct::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUCProduct', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUCProduct::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get hostnameorip value
     * @return string|null
     */
    public function getHostnameorip()
    {
        return $this->hostnameorip;
    }
    /**
     * Set hostnameorip value
     * @param string $hostnameorip
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setHostnameorip($hostnameorip = null)
    {
        // validation for constraint: string
        if (!is_null($hostnameorip) && !is_string($hostnameorip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostnameorip, true), gettype($hostnameorip)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($hostnameorip) && mb_strlen($hostnameorip) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($hostnameorip)), __LINE__);
        }
        $this->hostnameorip = $hostnameorip;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XConnectProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get ucServiceXml value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getUcServiceXml()
    {
        return $this->ucServiceXml;
    }
    /**
     * Set ucServiceXml value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setUcServiceXml(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml = null)
    {
        $this->ucServiceXml = $ucServiceXml;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUcService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
