<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSipDialRules StructType
 * @subpackage Structs
 */
class RSipDialRules extends AbstractStructBase
{
    /**
     * The dialPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPattern;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The patterns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Patterns
     */
    public $patterns;
    /**
     * The plars
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Plars
     */
    public $plars;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSipDialRules
     * @uses RSipDialRules::setDialPattern()
     * @uses RSipDialRules::setName()
     * @uses RSipDialRules::setDescription()
     * @uses RSipDialRules::setPatterns()
     * @uses RSipDialRules::setPlars()
     * @uses RSipDialRules::setUuid()
     * @param string $dialPattern
     * @param string $name
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars
     * @param string $uuid
     */
    public function __construct($dialPattern = null, $name = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns = null, \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars = null, $uuid = null)
    {
        $this
            ->setDialPattern($dialPattern)
            ->setName($name)
            ->setDescription($description)
            ->setPatterns($patterns)
            ->setPlars($plars)
            ->setUuid($uuid);
    }
    /**
     * Get dialPattern value
     * @return string|null
     */
    public function getDialPattern()
    {
        return $this->dialPattern;
    }
    /**
     * Set dialPattern value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RSipDialRules
     */
    public function setDialPattern($dialPattern = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::valueIsValid($dialPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern', is_array($dialPattern) ? implode(', ', $dialPattern) : var_export($dialPattern, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::getValidValues())), __LINE__);
        }
        $this->dialPattern = $dialPattern;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RSipDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RSipDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get patterns value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Patterns|null
     */
    public function getPatterns()
    {
        return $this->patterns;
    }
    /**
     * Set patterns value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RSipDialRules
     */
    public function setPatterns(\Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns = null)
    {
        $this->patterns = $patterns;
        return $this;
    }
    /**
     * Get plars value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Plars|null
     */
    public function getPlars()
    {
        return $this->plars;
    }
    /**
     * Set plars value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RSipDialRules
     */
    public function setPlars(\Losc\CucmBundle\Model\Webservice\StructType\Plars $plars = null)
    {
        $this->plars = $plars;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RSipDialRules
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
