<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRoutePattern StructType
 * @subpackage Structs
 */
class RRoutePattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The dialPlanWizardGenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The supportOverlapSending
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for a translation pattern.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $supportOverlapSending;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The allowDeviceOverride
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowDeviceOverride;
    /**
     * The provideOutsideDialtone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Destination
     */
    public $destination;
    /**
     * The authorizationCodeRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authorizationCodeRequired;
    /**
     * The authorizationLevelRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authorizationLevelRequired;
    /**
     * The clientCodeRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $clientCodeRequired;
    /**
     * The withTag
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withTag;
    /**
     * The withValueClause
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withValueClause;
    /**
     * The isdnNsfInfoElement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public $isdnNsfInfoElement;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClass;
    /**
     * The enableDccEnforcement
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDccEnforcement;
    /**
     * The blockedCallPercentage
     * Meta information extracted from the WSDL
     * - documentation: This tag is only valid when value of enabledccenforcement is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blockedCallPercentage;
    /**
     * The externalCallControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $externalCallControl;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRoutePattern
     * @uses RRoutePattern::setPattern()
     * @uses RRoutePattern::setDescription()
     * @uses RRoutePattern::setUsage()
     * @uses RRoutePattern::setRoutePartitionName()
     * @uses RRoutePattern::setBlockEnable()
     * @uses RRoutePattern::setCalledPartyTransformationMask()
     * @uses RRoutePattern::setCallingPartyTransformationMask()
     * @uses RRoutePattern::setUseCallingPartyPhoneMask()
     * @uses RRoutePattern::setCallingPartyPrefixDigits()
     * @uses RRoutePattern::setDialPlanName()
     * @uses RRoutePattern::setDialPlanWizardGenId()
     * @uses RRoutePattern::setDigitDiscardInstructionName()
     * @uses RRoutePattern::setNetworkLocation()
     * @uses RRoutePattern::setPatternUrgency()
     * @uses RRoutePattern::setPrefixDigitsOut()
     * @uses RRoutePattern::setRouteFilterName()
     * @uses RRoutePattern::setCallingLinePresentationBit()
     * @uses RRoutePattern::setCallingNamePresentationBit()
     * @uses RRoutePattern::setConnectedLinePresentationBit()
     * @uses RRoutePattern::setConnectedNamePresentationBit()
     * @uses RRoutePattern::setSupportOverlapSending()
     * @uses RRoutePattern::setPatternPrecedence()
     * @uses RRoutePattern::setReleaseClause()
     * @uses RRoutePattern::setAllowDeviceOverride()
     * @uses RRoutePattern::setProvideOutsideDialtone()
     * @uses RRoutePattern::setCallingPartyNumberingPlan()
     * @uses RRoutePattern::setCallingPartyNumberType()
     * @uses RRoutePattern::setCalledPartyNumberingPlan()
     * @uses RRoutePattern::setCalledPartyNumberType()
     * @uses RRoutePattern::setDestination()
     * @uses RRoutePattern::setAuthorizationCodeRequired()
     * @uses RRoutePattern::setAuthorizationLevelRequired()
     * @uses RRoutePattern::setClientCodeRequired()
     * @uses RRoutePattern::setWithTag()
     * @uses RRoutePattern::setWithValueClause()
     * @uses RRoutePattern::setIsdnNsfInfoElement()
     * @uses RRoutePattern::setResourcePriorityNamespaceName()
     * @uses RRoutePattern::setRouteClass()
     * @uses RRoutePattern::setEnableDccEnforcement()
     * @uses RRoutePattern::setBlockedCallPercentage()
     * @uses RRoutePattern::setExternalCallControl()
     * @uses RRoutePattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param string $dialPlanWizardGenId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $networkLocation
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $supportOverlapSending
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $allowDeviceOverride
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Destination $destination
     * @param string $authorizationCodeRequired
     * @param string $authorizationLevelRequired
     * @param string $clientCodeRequired
     * @param string $withTag
     * @param string $withValueClause
     * @param \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @param string $routeClass
     * @param string $enableDccEnforcement
     * @param string $blockedCallPercentage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $blockEnable = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, $dialPlanWizardGenId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $networkLocation = null, $patternUrgency = null, $prefixDigitsOut = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, $supportOverlapSending = null, $patternPrecedence = null, $releaseClause = null, $allowDeviceOverride = null, $provideOutsideDialtone = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, \Losc\CucmBundle\Model\Webservice\StructType\Destination $destination = null, $authorizationCodeRequired = null, $authorizationLevelRequired = null, $clientCodeRequired = null, $withTag = null, $withValueClause = null, \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null, $routeClass = null, $enableDccEnforcement = null, $blockedCallPercentage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setNetworkLocation($networkLocation)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setSupportOverlapSending($supportOverlapSending)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setAllowDeviceOverride($allowDeviceOverride)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setDestination($destination)
            ->setAuthorizationCodeRequired($authorizationCodeRequired)
            ->setAuthorizationLevelRequired($authorizationLevelRequired)
            ->setClientCodeRequired($clientCodeRequired)
            ->setWithTag($withTag)
            ->setWithValueClause($withValueClause)
            ->setIsdnNsfInfoElement($isdnNsfInfoElement)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setEnableDccEnforcement($enableDccEnforcement)
            ->setBlockedCallPercentage($blockedCallPercentage)
            ->setExternalCallControl($externalCallControl)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockEnable, true), gettype($blockEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($blockEnable, true)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyTransformationMask, true), gettype($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useCallingPartyPhoneMask) ? implode(', ', $useCallingPartyPhoneMask) : var_export($useCallingPartyPhoneMask, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDialPlanName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dialPlanWizardGenId) ? implode(', ', $dialPlanWizardGenId) : var_export($dialPlanWizardGenId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patternUrgency, true), gettype($patternUrgency)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($patternUrgency, true)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigitsOut, true), gettype($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setRouteFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLinePresentationBit) ? implode(', ', $callingLinePresentationBit) : var_export($callingLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingNamePresentationBit) ? implode(', ', $callingNamePresentationBit) : var_export($callingNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedLinePresentationBit) ? implode(', ', $connectedLinePresentationBit) : var_export($connectedLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedNamePresentationBit) ? implode(', ', $connectedNamePresentationBit) : var_export($connectedNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get supportOverlapSending value
     * @return string|null
     */
    public function getSupportOverlapSending()
    {
        return $this->supportOverlapSending;
    }
    /**
     * Set supportOverlapSending value
     * @param string $supportOverlapSending
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setSupportOverlapSending($supportOverlapSending = null)
    {
        // validation for constraint: string
        if (!is_null($supportOverlapSending) && !is_string($supportOverlapSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supportOverlapSending, true), gettype($supportOverlapSending)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($supportOverlapSending) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $supportOverlapSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($supportOverlapSending, true)), __LINE__);
        }
        $this->supportOverlapSending = $supportOverlapSending;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setReleaseClause($releaseClause = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue', is_array($releaseClause) ? implode(', ', $releaseClause) : var_export($releaseClause, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get allowDeviceOverride value
     * @return string|null
     */
    public function getAllowDeviceOverride()
    {
        return $this->allowDeviceOverride;
    }
    /**
     * Set allowDeviceOverride value
     * @param string $allowDeviceOverride
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setAllowDeviceOverride($allowDeviceOverride = null)
    {
        // validation for constraint: string
        if (!is_null($allowDeviceOverride) && !is_string($allowDeviceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowDeviceOverride, true), gettype($allowDeviceOverride)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowDeviceOverride) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowDeviceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowDeviceOverride, true)), __LINE__);
        }
        $this->allowDeviceOverride = $allowDeviceOverride;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = null)
    {
        // validation for constraint: string
        if (!is_null($provideOutsideDialtone) && !is_string($provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provideOutsideDialtone, true), gettype($provideOutsideDialtone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($provideOutsideDialtone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($provideOutsideDialtone, true)), __LINE__);
        }
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($callingPartyNumberingPlan) ? implode(', ', $callingPartyNumberingPlan) : var_export($callingPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($callingPartyNumberType) ? implode(', ', $callingPartyNumberType) : var_export($callingPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($calledPartyNumberingPlan) ? implode(', ', $calledPartyNumberingPlan) : var_export($calledPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($calledPartyNumberType) ? implode(', ', $calledPartyNumberType) : var_export($calledPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get destination value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Destination|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Destination $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDestination(\Losc\CucmBundle\Model\Webservice\StructType\Destination $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get authorizationCodeRequired value
     * @return string|null
     */
    public function getAuthorizationCodeRequired()
    {
        return $this->authorizationCodeRequired;
    }
    /**
     * Set authorizationCodeRequired value
     * @param string $authorizationCodeRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setAuthorizationCodeRequired($authorizationCodeRequired = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCodeRequired) && !is_string($authorizationCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCodeRequired, true), gettype($authorizationCodeRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($authorizationCodeRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $authorizationCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($authorizationCodeRequired, true)), __LINE__);
        }
        $this->authorizationCodeRequired = $authorizationCodeRequired;
        return $this;
    }
    /**
     * Get authorizationLevelRequired value
     * @return string|null
     */
    public function getAuthorizationLevelRequired()
    {
        return $this->authorizationLevelRequired;
    }
    /**
     * Set authorizationLevelRequired value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authorizationLevelRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setAuthorizationLevelRequired($authorizationLevelRequired = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($authorizationLevelRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($authorizationLevelRequired) ? implode(', ', $authorizationLevelRequired) : var_export($authorizationLevelRequired, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->authorizationLevelRequired = $authorizationLevelRequired;
        return $this;
    }
    /**
     * Get clientCodeRequired value
     * @return string|null
     */
    public function getClientCodeRequired()
    {
        return $this->clientCodeRequired;
    }
    /**
     * Set clientCodeRequired value
     * @param string $clientCodeRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setClientCodeRequired($clientCodeRequired = null)
    {
        // validation for constraint: string
        if (!is_null($clientCodeRequired) && !is_string($clientCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCodeRequired, true), gettype($clientCodeRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($clientCodeRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $clientCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($clientCodeRequired, true)), __LINE__);
        }
        $this->clientCodeRequired = $clientCodeRequired;
        return $this;
    }
    /**
     * Get withTag value
     * @return string|null
     */
    public function getWithTag()
    {
        return $this->withTag;
    }
    /**
     * Set withTag value
     * @param string $withTag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setWithTag($withTag = null)
    {
        // validation for constraint: string
        if (!is_null($withTag) && !is_string($withTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withTag, true), gettype($withTag)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($withTag) && mb_strlen($withTag) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($withTag)), __LINE__);
        }
        $this->withTag = $withTag;
        return $this;
    }
    /**
     * Get withValueClause value
     * @return string|null
     */
    public function getWithValueClause()
    {
        return $this->withValueClause;
    }
    /**
     * Set withValueClause value
     * @param string $withValueClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setWithValueClause($withValueClause = null)
    {
        // validation for constraint: string
        if (!is_null($withValueClause) && !is_string($withValueClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withValueClause, true), gettype($withValueClause)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($withValueClause) && mb_strlen($withValueClause) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($withValueClause)), __LINE__);
        }
        $this->withValueClause = $withValueClause;
        return $this;
    }
    /**
     * Get isdnNsfInfoElement value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement|null
     */
    public function getIsdnNsfInfoElement()
    {
        return $this->isdnNsfInfoElement;
    }
    /**
     * Set isdnNsfInfoElement value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setIsdnNsfInfoElement(\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement = null)
    {
        $this->isdnNsfInfoElement = $isdnNsfInfoElement;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setResourcePriorityNamespaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return string|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClass
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setRouteClass($routeClass = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::valueIsValid($routeClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass', is_array($routeClass) ? implode(', ', $routeClass) : var_export($routeClass, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::getValidValues())), __LINE__);
        }
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get enableDccEnforcement value
     * @return string|null
     */
    public function getEnableDccEnforcement()
    {
        return $this->enableDccEnforcement;
    }
    /**
     * Set enableDccEnforcement value
     * @param string $enableDccEnforcement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setEnableDccEnforcement($enableDccEnforcement = null)
    {
        // validation for constraint: string
        if (!is_null($enableDccEnforcement) && !is_string($enableDccEnforcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableDccEnforcement, true), gettype($enableDccEnforcement)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableDccEnforcement) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDccEnforcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableDccEnforcement, true)), __LINE__);
        }
        $this->enableDccEnforcement = $enableDccEnforcement;
        return $this;
    }
    /**
     * Get blockedCallPercentage value
     * @return string|null
     */
    public function getBlockedCallPercentage()
    {
        return $this->blockedCallPercentage;
    }
    /**
     * Set blockedCallPercentage value
     * @param string $blockedCallPercentage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setBlockedCallPercentage($blockedCallPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($blockedCallPercentage) && !is_string($blockedCallPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockedCallPercentage, true), gettype($blockedCallPercentage)), __LINE__);
        }
        $this->blockedCallPercentage = $blockedCallPercentage;
        return $this;
    }
    /**
     * Get externalCallControl value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExternalCallControl()
    {
        return $this->externalCallControl;
    }
    /**
     * Set externalCallControl value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setExternalCallControl(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl = null)
    {
        $this->externalCallControl = $externalCallControl;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
