<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRouteGroupMember StructType
 * @subpackage Structs
 */
class RRouteGroupMember extends AbstractStructBase
{
    /**
     * The deviceSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSelectionOrder;
    /**
     * The dialPlanWizardGenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $deviceName;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRouteGroupMember
     * @uses RRouteGroupMember::setDeviceSelectionOrder()
     * @uses RRouteGroupMember::setDialPlanWizardGenId()
     * @uses RRouteGroupMember::setDeviceName()
     * @uses RRouteGroupMember::setPort()
     * @uses RRouteGroupMember::setUuid()
     * @param string $deviceSelectionOrder
     * @param string $dialPlanWizardGenId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @param string $port
     * @param string $uuid
     */
    public function __construct($deviceSelectionOrder = null, $dialPlanWizardGenId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null, $port = null, $uuid = null)
    {
        $this
            ->setDeviceSelectionOrder($deviceSelectionOrder)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setDeviceName($deviceName)
            ->setPort($port)
            ->setUuid($uuid);
    }
    /**
     * Get deviceSelectionOrder value
     * @return string|null
     */
    public function getDeviceSelectionOrder()
    {
        return $this->deviceSelectionOrder;
    }
    /**
     * Set deviceSelectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSelectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteGroupMember
     */
    public function setDeviceSelectionOrder($deviceSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($deviceSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($deviceSelectionOrder) ? implode(', ', $deviceSelectionOrder) : var_export($deviceSelectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->deviceSelectionOrder = $deviceSelectionOrder;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteGroupMember
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dialPlanWizardGenId) ? implode(', ', $dialPlanWizardGenId) : var_export($dialPlanWizardGenId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get deviceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteGroupMember
     */
    public function setDeviceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteGroupMember
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
