<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPhoneSecurityProfile StructType
 * @subpackage Structs
 */
class RPhoneSecurityProfile extends AbstractStructBase
{
    /**
     * The phoneType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneType;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPhoneSecurityProfile
     * @uses RPhoneSecurityProfile::setPhoneType()
     * @uses RPhoneSecurityProfile::setProtocol()
     * @uses RPhoneSecurityProfile::setName()
     * @uses RPhoneSecurityProfile::setDescription()
     * @uses RPhoneSecurityProfile::setDeviceSecurityMode()
     * @uses RPhoneSecurityProfile::setAuthenticationMode()
     * @uses RPhoneSecurityProfile::setKeySize()
     * @uses RPhoneSecurityProfile::setTftpEncryptedConfig()
     * @uses RPhoneSecurityProfile::setNonceValidityTime()
     * @uses RPhoneSecurityProfile::setTransportType()
     * @uses RPhoneSecurityProfile::setSipPhonePort()
     * @uses RPhoneSecurityProfile::setEnableDigestAuthentication()
     * @uses RPhoneSecurityProfile::setExcludeDigestCredentials()
     * @uses RPhoneSecurityProfile::setUuid()
     * @param string $phoneType
     * @param string $protocol
     * @param string $name
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     * @param string $uuid
     */
    public function __construct($phoneType = null, $protocol = null, $name = null, $description = null, $deviceSecurityMode = null, $authenticationMode = null, $keySize = null, $tftpEncryptedConfig = null, $nonceValidityTime = null, $transportType = null, $sipPhonePort = null, $enableDigestAuthentication = null, $excludeDigestCredentials = null, $uuid = null)
    {
        $this
            ->setPhoneType($phoneType)
            ->setProtocol($protocol)
            ->setName($name)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials)
            ->setUuid($uuid);
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XModel', is_array($phoneType) ? implode(', ', $phoneType) : var_export($phoneType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode', is_array($deviceSecurityMode) ? implode(', ', $deviceSecurityMode) : var_export($deviceSecurityMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode', is_array($authenticationMode) ? implode(', ', $authenticationMode) : var_export($authenticationMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize', is_array($keySize) ? implode(', ', $keySize) : var_export($keySize, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = null)
    {
        // validation for constraint: string
        if (!is_null($tftpEncryptedConfig) && !is_string($tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tftpEncryptedConfig, true), gettype($tftpEncryptedConfig)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($tftpEncryptedConfig) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($tftpEncryptedConfig, true)), __LINE__);
        }
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonceValidityTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setNonceValidityTime($nonceValidityTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($nonceValidityTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($nonceValidityTime) ? implode(', ', $nonceValidityTime) : var_export($nonceValidityTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setTransportType($transportType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTransport', is_array($transportType) ? implode(', ', $transportType) : var_export($transportType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhonePort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setSipPhonePort($sipPhonePort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($sipPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($sipPhonePort) ? implode(', ', $sipPhonePort) : var_export($sipPhonePort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($enableDigestAuthentication) && !is_string($enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableDigestAuthentication, true), gettype($enableDigestAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableDigestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableDigestAuthentication, true)), __LINE__);
        }
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($excludeDigestCredentials) && !is_string($excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excludeDigestCredentials, true), gettype($excludeDigestCredentials)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($excludeDigestCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($excludeDigestCredentials, true)), __LINE__);
        }
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
