<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RNetworkAccessProfile StructType
 * @subpackage Structs
 */
class RNetworkAccessProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The vpnRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vpnRequired;
    /**
     * The proxySettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxySettings;
    /**
     * The proxyHostname
     * Meta information extracted from the WSDL
     * - documentation: This tag corresponds to Proxy Auto-Config (PAC) Location when proxy setting is set to Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyHostname;
    /**
     * The proxyPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyPort;
    /**
     * The proxyRequiresAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $proxyRequiresAuthentication;
    /**
     * The provideSharedCredentials
     * Meta information extracted from the WSDL
     * - documentation: This tag is used for validation and does not correspond to any field in database.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideSharedCredentials;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RNetworkAccessProfile
     * @uses RNetworkAccessProfile::setName()
     * @uses RNetworkAccessProfile::setDescription()
     * @uses RNetworkAccessProfile::setVpnRequired()
     * @uses RNetworkAccessProfile::setProxySettings()
     * @uses RNetworkAccessProfile::setProxyHostname()
     * @uses RNetworkAccessProfile::setProxyPort()
     * @uses RNetworkAccessProfile::setProxyRequiresAuthentication()
     * @uses RNetworkAccessProfile::setProvideSharedCredentials()
     * @uses RNetworkAccessProfile::setUsername()
     * @uses RNetworkAccessProfile::setPassword()
     * @uses RNetworkAccessProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $vpnRequired
     * @param string $proxySettings
     * @param string $proxyHostname
     * @param string $proxyPort
     * @param string $proxyRequiresAuthentication
     * @param string $provideSharedCredentials
     * @param string $username
     * @param string $password
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $vpnRequired = null, $proxySettings = null, $proxyHostname = null, $proxyPort = null, $proxyRequiresAuthentication = null, $provideSharedCredentials = null, $username = null, $password = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setVpnRequired($vpnRequired)
            ->setProxySettings($proxySettings)
            ->setProxyHostname($proxyHostname)
            ->setProxyPort($proxyPort)
            ->setProxyRequiresAuthentication($proxyRequiresAuthentication)
            ->setProvideSharedCredentials($provideSharedCredentials)
            ->setUsername($username)
            ->setPassword($password)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnRequired value
     * @return string|null
     */
    public function getVpnRequired()
    {
        return $this->vpnRequired;
    }
    /**
     * Set vpnRequired value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vpnRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setVpnRequired($vpnRequired = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($vpnRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($vpnRequired) ? implode(', ', $vpnRequired) : var_export($vpnRequired, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->vpnRequired = $vpnRequired;
        return $this;
    }
    /**
     * Get proxySettings value
     * @return string|null
     */
    public function getProxySettings()
    {
        return $this->proxySettings;
    }
    /**
     * Set proxySettings value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxySettings
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setProxySettings($proxySettings = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::valueIsValid($proxySettings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy', is_array($proxySettings) ? implode(', ', $proxySettings) : var_export($proxySettings, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHTTPProxy::getValidValues())), __LINE__);
        }
        $this->proxySettings = $proxySettings;
        return $this;
    }
    /**
     * Get proxyHostname value
     * @return string|null
     */
    public function getProxyHostname()
    {
        return $this->proxyHostname;
    }
    /**
     * Set proxyHostname value
     * @param string $proxyHostname
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setProxyHostname($proxyHostname = null)
    {
        // validation for constraint: string
        if (!is_null($proxyHostname) && !is_string($proxyHostname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proxyHostname, true), gettype($proxyHostname)), __LINE__);
        }
        $this->proxyHostname = $proxyHostname;
        return $this;
    }
    /**
     * Get proxyPort value
     * @return string|null
     */
    public function getProxyPort()
    {
        return $this->proxyPort;
    }
    /**
     * Set proxyPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $proxyPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setProxyPort($proxyPort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($proxyPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($proxyPort) ? implode(', ', $proxyPort) : var_export($proxyPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->proxyPort = $proxyPort;
        return $this;
    }
    /**
     * Get proxyRequiresAuthentication value
     * @return string|null
     */
    public function getProxyRequiresAuthentication()
    {
        return $this->proxyRequiresAuthentication;
    }
    /**
     * Set proxyRequiresAuthentication value
     * @param string $proxyRequiresAuthentication
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setProxyRequiresAuthentication($proxyRequiresAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($proxyRequiresAuthentication) && !is_string($proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proxyRequiresAuthentication, true), gettype($proxyRequiresAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($proxyRequiresAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $proxyRequiresAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($proxyRequiresAuthentication, true)), __LINE__);
        }
        $this->proxyRequiresAuthentication = $proxyRequiresAuthentication;
        return $this;
    }
    /**
     * Get provideSharedCredentials value
     * @return string|null
     */
    public function getProvideSharedCredentials()
    {
        return $this->provideSharedCredentials;
    }
    /**
     * Set provideSharedCredentials value
     * @param string $provideSharedCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setProvideSharedCredentials($provideSharedCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($provideSharedCredentials) && !is_string($provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provideSharedCredentials, true), gettype($provideSharedCredentials)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($provideSharedCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideSharedCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($provideSharedCredentials, true)), __LINE__);
        }
        $this->provideSharedCredentials = $provideSharedCredentials;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RNetworkAccessProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
