<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMobilityProfile StructType
 * @subpackage Structs
 */
class RMobilityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mobileClientCallingOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobileClientCallingOption;
    /**
     * The dvofServiceAccessNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dvofServiceAccessNumber;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RDirn
     */
    public $dirn;
    /**
     * The dvorCallerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dvorCallerId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMobilityProfile
     * @uses RMobilityProfile::setName()
     * @uses RMobilityProfile::setDescription()
     * @uses RMobilityProfile::setMobileClientCallingOption()
     * @uses RMobilityProfile::setDvofServiceAccessNumber()
     * @uses RMobilityProfile::setDirn()
     * @uses RMobilityProfile::setDvorCallerId()
     * @uses RMobilityProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $mobileClientCallingOption
     * @param string $dvofServiceAccessNumber
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn
     * @param string $dvorCallerId
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $mobileClientCallingOption = null, $dvofServiceAccessNumber = null, \Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn = null, $dvorCallerId = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMobileClientCallingOption($mobileClientCallingOption)
            ->setDvofServiceAccessNumber($dvofServiceAccessNumber)
            ->setDirn($dirn)
            ->setDvorCallerId($dvorCallerId)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mobileClientCallingOption value
     * @return string|null
     */
    public function getMobileClientCallingOption()
    {
        return $this->mobileClientCallingOption;
    }
    /**
     * Set mobileClientCallingOption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialViaOffice::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialViaOffice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileClientCallingOption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setMobileClientCallingOption($mobileClientCallingOption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDialViaOffice::valueIsValid($mobileClientCallingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDialViaOffice', is_array($mobileClientCallingOption) ? implode(', ', $mobileClientCallingOption) : var_export($mobileClientCallingOption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDialViaOffice::getValidValues())), __LINE__);
        }
        $this->mobileClientCallingOption = $mobileClientCallingOption;
        return $this;
    }
    /**
     * Get dvofServiceAccessNumber value
     * @return string|null
     */
    public function getDvofServiceAccessNumber()
    {
        return $this->dvofServiceAccessNumber;
    }
    /**
     * Set dvofServiceAccessNumber value
     * @param string $dvofServiceAccessNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setDvofServiceAccessNumber($dvofServiceAccessNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dvofServiceAccessNumber) && !is_string($dvofServiceAccessNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dvofServiceAccessNumber, true), gettype($dvofServiceAccessNumber)), __LINE__);
        }
        $this->dvofServiceAccessNumber = $dvofServiceAccessNumber;
        return $this;
    }
    /**
     * Get dirn value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setDirn(\Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get dvorCallerId value
     * @return string|null
     */
    public function getDvorCallerId()
    {
        return $this->dvorCallerId;
    }
    /**
     * Set dvorCallerId value
     * @param string $dvorCallerId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setDvorCallerId($dvorCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($dvorCallerId) && !is_string($dvorCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dvorCallerId, true), gettype($dvorCallerId)), __LINE__);
        }
        $this->dvorCallerId = $dvorCallerId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMobilityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
