<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeEnrolledPattern StructType
 * @subpackage Structs
 */
class RImeEnrolledPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeEnrolledPattern
     * @uses RImeEnrolledPattern::setPattern()
     * @uses RImeEnrolledPattern::setDescription()
     * @uses RImeEnrolledPattern::setImeEnrolledPatternGroupName()
     * @uses RImeEnrolledPattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RImeEnrolledPattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pattern) && mb_strlen($pattern) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RImeEnrolledPattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return $this->imeEnrolledPatternGroupName;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RImeEnrolledPattern
     */
    public function setImeEnrolledPatternGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RImeEnrolledPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
