<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RHuntForwardInfoNoAnswer StructType
 * @subpackage Structs
 */
class RHuntForwardInfoNoAnswer extends AbstractStructBase
{
    /**
     * The usePersonalPreferences
     * Meta information extracted from the WSDL
     * - documentation: Use original Called DN forward no-coverage settings
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePersonalPreferences;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The maxHuntduration
     * Meta information extracted from the WSDL
     * - documentation: Value "-1" in the response means no value has been assigned and internally the CM will use default setting i.e., 1800s.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxHuntduration;
    /**
     * Constructor method for RHuntForwardInfoNoAnswer
     * @uses RHuntForwardInfoNoAnswer::setUsePersonalPreferences()
     * @uses RHuntForwardInfoNoAnswer::setCallingSearchSpaceName()
     * @uses RHuntForwardInfoNoAnswer::setDestination()
     * @uses RHuntForwardInfoNoAnswer::setMaxHuntduration()
     * @param string $usePersonalPreferences
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param string $destination
     * @param string $maxHuntduration
     */
    public function __construct($usePersonalPreferences = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, $destination = null, $maxHuntduration = null)
    {
        $this
            ->setUsePersonalPreferences($usePersonalPreferences)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination)
            ->setMaxHuntduration($maxHuntduration);
    }
    /**
     * Get usePersonalPreferences value
     * @return string|null
     */
    public function getUsePersonalPreferences()
    {
        return $this->usePersonalPreferences;
    }
    /**
     * Set usePersonalPreferences value
     * @param string $usePersonalPreferences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RHuntForwardInfoNoAnswer
     */
    public function setUsePersonalPreferences($usePersonalPreferences = null)
    {
        // validation for constraint: string
        if (!is_null($usePersonalPreferences) && !is_string($usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePersonalPreferences, true), gettype($usePersonalPreferences)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($usePersonalPreferences) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($usePersonalPreferences, true)), __LINE__);
        }
        $this->usePersonalPreferences = $usePersonalPreferences;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RHuntForwardInfoNoAnswer
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RHuntForwardInfoNoAnswer
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($destination) && mb_strlen($destination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get maxHuntduration value
     * @return string|null
     */
    public function getMaxHuntduration()
    {
        return $this->maxHuntduration;
    }
    /**
     * Set maxHuntduration value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxHuntduration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RHuntForwardInfoNoAnswer
     */
    public function setMaxHuntduration($maxHuntduration = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxHuntduration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxHuntduration) ? implode(', ', $maxHuntduration) : var_export($maxHuntduration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxHuntduration = $maxHuntduration;
        return $this;
    }
}
