<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCiscoCatalyst6000T1VoIPGatewayT1 StructType
 * @subpackage Structs
 */
class RCiscoCatalyst6000T1VoIPGatewayT1 extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The ports
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public $ports;
    /**
     * The trunkSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkSelectionOrder;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csuParam;
    /**
     * The digitSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pcmType;
    /**
     * The fdlChannel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fdlChannel;
    /**
     * The yellowAlarm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $yellowAlarm;
    /**
     * The zeroSupression
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zeroSupression;
    /**
     * The smdiBasePort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smdiBasePort;
    /**
     * The handleDtmfPrecedenceSignals
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $handleDtmfPrecedenceSignals;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCiscoCatalyst6000T1VoIPGatewayT1
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setDescription()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setProduct()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setModel()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setClass()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setProtocol()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setProtocolSide()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setCallingSearchSpaceName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setDevicePoolName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setCommonDeviceConfigName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setNetworkLocation()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setLocationName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setMediaResourceListName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setAutomatedAlternateRoutingCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setAarNeighborhoodName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setLoadInformation()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setVendorConfig()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setTraceFlag()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setMlppDomainId()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setMlppIndicationStatus()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setPreemption()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setUseTrustedRelayPoint()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setRetryVideoCallAsAudio()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setCgpnTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setUseDevicePoolCgpnTransformCss()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setGeoLocationName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setSendGeoLocation()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setPorts()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setTrunkSelectionOrder()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setClockReference()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setCsuParam()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setDigitSending()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setPcmType()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setFdlChannel()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setYellowAlarm()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setZeroSupression()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setSmdiBasePort()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setHandleDtmfPrecedenceSignals()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setCdpnTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setUseDevicePoolCdpnTransformCss()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setGeoLocationFilterName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setPstnAccess()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setImeE164TransformationName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayT1::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $sendGeoLocation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Ports $ports
     * @param string $trunkSelectionOrder
     * @param string $clockReference
     * @param string $csuParam
     * @param string $digitSending
     * @param string $pcmType
     * @param string $fdlChannel
     * @param string $yellowAlarm
     * @param string $zeroSupression
     * @param string $smdiBasePort
     * @param string $handleDtmfPrecedenceSignals
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $pstnAccess
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $sendGeoLocation = null, \Losc\CucmBundle\Model\Webservice\StructType\Ports $ports = null, $trunkSelectionOrder = null, $clockReference = null, $csuParam = null, $digitSending = null, $pcmType = null, $fdlChannel = null, $yellowAlarm = null, $zeroSupression = null, $smdiBasePort = null, $handleDtmfPrecedenceSignals = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $pstnAccess = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setPorts($ports)
            ->setTrunkSelectionOrder($trunkSelectionOrder)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDigitSending($digitSending)
            ->setPcmType($pcmType)
            ->setFdlChannel($fdlChannel)
            ->setYellowAlarm($yellowAlarm)
            ->setZeroSupression($zeroSupression)
            ->setSmdiBasePort($smdiBasePort)
            ->setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setMediaResourceListName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setAutomatedAlternateRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setLoadInformation(\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setVendorConfig(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceFlag, true), gettype($traceFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($traceFlag, true)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppDomainId, true), gettype($mlppDomainId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mlppDomainId) && mb_strlen($mlppDomainId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryVideoCallAsAudio, true), gettype($retryVideoCallAsAudio)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setCgpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setGeoLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendGeoLocation, true), gettype($sendGeoLocation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendGeoLocation, true)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get ports value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Ports $ports
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setPorts(\Losc\CucmBundle\Model\Webservice\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get trunkSelectionOrder value
     * @return string|null
     */
    public function getTrunkSelectionOrder()
    {
        return $this->trunkSelectionOrder;
    }
    /**
     * Set trunkSelectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkSelectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setTrunkSelectionOrder($trunkSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::valueIsValid($trunkSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder', is_array($trunkSelectionOrder) ? implode(', ', $trunkSelectionOrder) : var_export($trunkSelectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->trunkSelectionOrder = $trunkSelectionOrder;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference', is_array($clockReference) ? implode(', ', $clockReference) : var_export($clockReference, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam', is_array($csuParam) ? implode(', ', $csuParam) : var_export($csuParam, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setDigitSending($digitSending = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending', is_array($digitSending) ? implode(', ', $digitSending) : var_export($digitSending, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XEncode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XEncode', is_array($pcmType) ? implode(', ', $pcmType) : var_export($pcmType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get fdlChannel value
     * @return string|null
     */
    public function getFdlChannel()
    {
        return $this->fdlChannel;
    }
    /**
     * Set fdlChannel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XFDLChannel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XFDLChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fdlChannel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setFdlChannel($fdlChannel = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XFDLChannel::valueIsValid($fdlChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XFDLChannel', is_array($fdlChannel) ? implode(', ', $fdlChannel) : var_export($fdlChannel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XFDLChannel::getValidValues())), __LINE__);
        }
        $this->fdlChannel = $fdlChannel;
        return $this;
    }
    /**
     * Get yellowAlarm value
     * @return string|null
     */
    public function getYellowAlarm()
    {
        return $this->yellowAlarm;
    }
    /**
     * Set yellowAlarm value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XYellowAlarm::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XYellowAlarm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yellowAlarm
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setYellowAlarm($yellowAlarm = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XYellowAlarm::valueIsValid($yellowAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XYellowAlarm', is_array($yellowAlarm) ? implode(', ', $yellowAlarm) : var_export($yellowAlarm, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XYellowAlarm::getValidValues())), __LINE__);
        }
        $this->yellowAlarm = $yellowAlarm;
        return $this;
    }
    /**
     * Get zeroSupression value
     * @return string|null
     */
    public function getZeroSupression()
    {
        return $this->zeroSupression;
    }
    /**
     * Set zeroSupression value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XZeroSuppression::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XZeroSuppression::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zeroSupression
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setZeroSupression($zeroSupression = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XZeroSuppression::valueIsValid($zeroSupression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XZeroSuppression', is_array($zeroSupression) ? implode(', ', $zeroSupression) : var_export($zeroSupression, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XZeroSuppression::getValidValues())), __LINE__);
        }
        $this->zeroSupression = $zeroSupression;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string|null
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smdiBasePort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setSmdiBasePort($smdiBasePort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($smdiBasePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($smdiBasePort) ? implode(', ', $smdiBasePort) : var_export($smdiBasePort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get handleDtmfPrecedenceSignals value
     * @return string|null
     */
    public function getHandleDtmfPrecedenceSignals()
    {
        return $this->handleDtmfPrecedenceSignals;
    }
    /**
     * Set handleDtmfPrecedenceSignals value
     * @param string $handleDtmfPrecedenceSignals
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals = null)
    {
        // validation for constraint: string
        if (!is_null($handleDtmfPrecedenceSignals) && !is_string($handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleDtmfPrecedenceSignals, true), gettype($handleDtmfPrecedenceSignals)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($handleDtmfPrecedenceSignals) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($handleDtmfPrecedenceSignals, true)), __LINE__);
        }
        $this->handleDtmfPrecedenceSignals = $handleDtmfPrecedenceSignals;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setCdpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCdpnTransformCss, true), gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setGeoLocationFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnAccess, true), gettype($pstnAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pstnAccess, true)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setImeE164TransformationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayT1
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
