<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdRequestingService StructType
 * @subpackage Structs
 */
class RCcdRequestingService extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The learnedPatternPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The pstnPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnPrefix;
    /**
     * The associatedTrunks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks
     */
    public $associatedTrunks;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdRequestingService
     * @uses RCcdRequestingService::setName()
     * @uses RCcdRequestingService::setDescription()
     * @uses RCcdRequestingService::setIsActivated()
     * @uses RCcdRequestingService::setRoutePartitionName()
     * @uses RCcdRequestingService::setLearnedPatternPrefix()
     * @uses RCcdRequestingService::setPstnPrefix()
     * @uses RCcdRequestingService::setAssociatedTrunks()
     * @uses RCcdRequestingService::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isActivated
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $learnedPatternPrefix
     * @param string $pstnPrefix
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isActivated = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $learnedPatternPrefix = null, $pstnPrefix = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setRoutePartitionName($routePartitionName)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setPstnPrefix($pstnPrefix)
            ->setAssociatedTrunks($associatedTrunks)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedPatternPrefix, true), gettype($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($learnedPatternPrefix) && mb_strlen($learnedPatternPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get pstnPrefix value
     * @return string|null
     */
    public function getPstnPrefix()
    {
        return $this->pstnPrefix;
    }
    /**
     * Set pstnPrefix value
     * @param string $pstnPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setPstnPrefix($pstnPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($pstnPrefix) && !is_string($pstnPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnPrefix, true), gettype($pstnPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pstnPrefix) && mb_strlen($pstnPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($pstnPrefix)), __LINE__);
        }
        $this->pstnPrefix = $pstnPrefix;
        return $this;
    }
    /**
     * Get associatedTrunks value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks|null
     */
    public function getAssociatedTrunks()
    {
        return $this->associatedTrunks;
    }
    /**
     * Set associatedTrunks value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setAssociatedTrunks(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks = null)
    {
        $this->associatedTrunks = $associatedTrunks;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcdRequestingService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
