<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAssignedPresenceServers StructType
 * @subpackage Structs
 */
class RAssignedPresenceServers extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The nodeUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nodeUsage;
    /**
     * The numUsers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numUsers;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAssignedPresenceServers
     * @uses RAssignedPresenceServers::setName()
     * @uses RAssignedPresenceServers::setDescription()
     * @uses RAssignedPresenceServers::setNodeUsage()
     * @uses RAssignedPresenceServers::setNumUsers()
     * @uses RAssignedPresenceServers::setUuid()
     * @param string $name
     * @param string $description
     * @param string $nodeUsage
     * @param string $numUsers
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $nodeUsage = null, $numUsers = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNodeUsage($nodeUsage)
            ->setNumUsers($numUsers)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAssignedPresenceServers
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAssignedPresenceServers
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nodeUsage value
     * @return string|null
     */
    public function getNodeUsage()
    {
        return $this->nodeUsage;
    }
    /**
     * Set nodeUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAssignedPresenceServers
     */
    public function setNodeUsage($nodeUsage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::valueIsValid($nodeUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage', is_array($nodeUsage) ? implode(', ', $nodeUsage) : var_export($nodeUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::getValidValues())), __LINE__);
        }
        $this->nodeUsage = $nodeUsage;
        return $this;
    }
    /**
     * Get numUsers value
     * @return string|null
     */
    public function getNumUsers()
    {
        return $this->numUsers;
    }
    /**
     * Set numUsers value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numUsers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAssignedPresenceServers
     */
    public function setNumUsers($numUsers = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numUsers) ? implode(', ', $numUsers) : var_export($numUsers, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numUsers = $numUsers;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAssignedPresenceServers
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
