<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class OXBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The directedCallParkId
     * Meta information extracted from the WSDL
     * - documentation: Only the uuid attribute is read
     * - base: xsd:string
     * - choice: directedCallParkId | directedCallParkDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta information extracted from the WSDL
     * - choice: directedCallParkId | directedCallParkDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * Constructor method for OXBLFDirectedCallPark
     * @uses OXBLFDirectedCallPark::setDirectedCallParkId()
     * @uses OXBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @param string $directedCallParkId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     */
    public function __construct($directedCallParkId = null, \Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition);
    }
    /**
     * Get directedCallParkId value
     * @return string|null
     */
    public function getDirectedCallParkId()
    {
        return isset($this->directedCallParkId) ? $this->directedCallParkId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectedCallParkId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectedCallParkId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectedCallParkIdForChoiceConstraintsFromSetDirectedCallParkId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'directedCallParkDnAndPartition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property directedCallParkId can\'t be set as the property %s is already set. Only one property must be set among these properties: directedCallParkId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set directedCallParkId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $directedCallParkId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        // validation for constraint: string
        if (!is_null($directedCallParkId) && !is_string($directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directedCallParkId, true), gettype($directedCallParkId)), __LINE__);
        }
        // validation for constraint: choice(directedCallParkId, directedCallParkDnAndPartition)
        if ('' !== ($directedCallParkIdChoiceErrorMessage = self::validateDirectedCallParkIdForChoiceConstraintsFromSetDirectedCallParkId($directedCallParkId))) {
            throw new \InvalidArgumentException($directedCallParkIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($directedCallParkId) && !preg_match('/\\{........-....-....-....-............\\}/', $directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($directedCallParkId, true)), __LINE__);
        }
        if (is_null($directedCallParkId) || (is_array($directedCallParkId) && empty($directedCallParkId))) {
            unset($this->directedCallParkId);
        } else {
            $this->directedCallParkId = $directedCallParkId;
        }
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition|null
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return isset($this->directedCallParkDnAndPartition) ? $this->directedCallParkDnAndPartition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectedCallParkDnAndPartition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectedCallParkDnAndPartition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectedCallParkDnAndPartitionForChoiceConstraintsFromSetDirectedCallParkDnAndPartition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'directedCallParkId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property directedCallParkDnAndPartition can\'t be set as the property %s is already set. Only one property must be set among these properties: directedCallParkDnAndPartition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        // validation for constraint: choice(directedCallParkId, directedCallParkDnAndPartition)
        if ('' !== ($directedCallParkDnAndPartitionChoiceErrorMessage = self::validateDirectedCallParkDnAndPartitionForChoiceConstraintsFromSetDirectedCallParkDnAndPartition($directedCallParkDnAndPartition))) {
            throw new \InvalidArgumentException($directedCallParkDnAndPartitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($directedCallParkDnAndPartition) || (is_array($directedCallParkDnAndPartition) && empty($directedCallParkDnAndPartition))) {
            unset($this->directedCallParkDnAndPartition);
        } else {
            $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        }
        return $this;
    }
}
