<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORSipProfile StructType
 * @subpackage Structs
 */
class ORSipProfile extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $telnetLevel;
    /**
     * The rerouteIncomingRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The rsvpOverSip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $rsvpOverSip;
    /**
     * The sipRe11XxEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $gClear;
    /**
     * The sipBandwidthModifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $sipBandwidthModifier;
    /**
     * The userAgentServerHeaderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $userAgentServerHeaderInfo;
    /**
     * The sipNormalizationScript
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $sipNormalizationScript;
    /**
     * The dialStringInterpretation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $acceptAudioCodecPreferences;
    /**
     * The resourcePriorityNamespace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The callingLineIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callingLineIdentification;
    /**
     * The videoCallTrafficClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta information extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $sdpTransparency;
    /**
     * The sipSessionRefreshMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORSipProfile
     * @uses ORSipProfile::setUserInfo()
     * @uses ORSipProfile::setDtmfDbLevel()
     * @uses ORSipProfile::setCallHoldRingback()
     * @uses ORSipProfile::setAnonymousCallBlock()
     * @uses ORSipProfile::setCallerIdBlock()
     * @uses ORSipProfile::setDndControl()
     * @uses ORSipProfile::setTelnetLevel()
     * @uses ORSipProfile::setRerouteIncomingRequest()
     * @uses ORSipProfile::setResourcePriorityNamespaceListName()
     * @uses ORSipProfile::setRsvpOverSip()
     * @uses ORSipProfile::setSipRe11XxEnabled()
     * @uses ORSipProfile::setGClear()
     * @uses ORSipProfile::setSipBandwidthModifier()
     * @uses ORSipProfile::setUserAgentServerHeaderInfo()
     * @uses ORSipProfile::setSipNormalizationScript()
     * @uses ORSipProfile::setDialStringInterpretation()
     * @uses ORSipProfile::setAcceptAudioCodecPreferences()
     * @uses ORSipProfile::setResourcePriorityNamespace()
     * @uses ORSipProfile::setCallingLineIdentification()
     * @uses ORSipProfile::setVideoCallTrafficClass()
     * @uses ORSipProfile::setSdpTransparency()
     * @uses ORSipProfile::setSipSessionRefreshMethod()
     * @uses ORSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses ORSipProfile::setCucmVersionInSipHeader()
     * @uses ORSipProfile::setConfidentialAccessLevelHeaders()
     * @uses ORSipProfile::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userInfo
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dtmfDbLevel
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callHoldRingback
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $anonymousCallBlock
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callerIdBlock
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dndControl
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $telnetLevel
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rerouteIncomingRequest
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceListName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rsvpOverSip
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipRe11XxEnabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $gClear
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipBandwidthModifier
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userAgentServerHeaderInfo
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipNormalizationScript
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialStringInterpretation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $acceptAudioCodecPreferences
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespace
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLineIdentification
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $videoCallTrafficClass
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sdpTransparency
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipSessionRefreshMethod
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $earlyOfferSuppVoiceCall
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cucmVersionInSipHeader
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $confidentialAccessLevelHeaders
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userInfo = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dtmfDbLevel = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callHoldRingback = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $anonymousCallBlock = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callerIdBlock = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dndControl = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $telnetLevel = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rerouteIncomingRequest = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceListName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rsvpOverSip = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipRe11XxEnabled = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $gClear = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipBandwidthModifier = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userAgentServerHeaderInfo = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipNormalizationScript = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialStringInterpretation = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $acceptAudioCodecPreferences = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespace = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLineIdentification = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $videoCallTrafficClass = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sdpTransparency = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipSessionRefreshMethod = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $earlyOfferSuppVoiceCall = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cucmVersionInSipHeader = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $confidentialAccessLevelHeaders = null, $uuid = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setRsvpOverSip($rsvpOverSip)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setUuid($uuid);
    }
    /**
     * Get userInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setUserInfo(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dtmfDbLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setDtmfDbLevel(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callHoldRingback
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setCallHoldRingback(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $anonymousCallBlock
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setAnonymousCallBlock(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callerIdBlock
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setCallerIdBlock(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dndControl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setDndControl(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $telnetLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setTelnetLevel(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rerouteIncomingRequest
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setRerouteIncomingRequest(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setResourcePriorityNamespaceListName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rsvpOverSip
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setRsvpOverSip(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipRe11XxEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setSipRe11XxEnabled(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $gClear
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setGClear(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipBandwidthModifier
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setSipBandwidthModifier(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userAgentServerHeaderInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setUserAgentServerHeaderInfo(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipNormalizationScript
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setSipNormalizationScript(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialStringInterpretation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setDialStringInterpretation(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $acceptAudioCodecPreferences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setAcceptAudioCodecPreferences(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespace
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setResourcePriorityNamespace(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLineIdentification
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setCallingLineIdentification(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $videoCallTrafficClass
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setVideoCallTrafficClass(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sdpTransparency
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setSdpTransparency(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipSessionRefreshMethod
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setSipSessionRefreshMethod(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $earlyOfferSuppVoiceCall
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setEarlyOfferSuppVoiceCall(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cucmVersionInSipHeader
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setCucmVersionInSipHeader(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $confidentialAccessLevelHeaders
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setConfidentialAccessLevelHeaders(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
