<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for languages StructType
 * @subpackage Structs
 */
class Languages extends XCommonMembersExtension
{
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision[]
     */
    public $language;
    /**
     * Constructor method for languages
     * @uses Languages::setLanguage()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get language value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision[]|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $languagesLanguageItem) {
            // validation for constraint: itemType
            if (!$languagesLanguageItem instanceof \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision) {
                $invalidValues[] = is_object($languagesLanguageItem) ? get_class($languagesLanguageItem) : sprintf('%s(%s)', gettype($languagesLanguageItem), var_export($languagesLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The language property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set language value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision[] $language
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Languages
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($language) && count($language) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Add item to language value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Languages
     */
    public function addToLanguage(\Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision) {
            throw new \InvalidArgumentException(sprintf('The language property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\XSelfProvision, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->language) && count($this->language) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->language)), __LINE__);
        }
        $this->language[] = $item;
        return $this;
    }
}
